/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableVoiceMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final InputFile voice;
    private final int duration;
    private final long replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;
    private final String caption;

    public static SendableVoiceMessageBuilder builder() {
        return new SendableVoiceMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.VOICE;
    }

    public String toString() {
        return "SendableVoiceMessage(voice=" + this.getVoice() + ", duration=" + this.getDuration() + ", replyTo=" + this.getReplyTo() + ", replyMarkup=" + this.getReplyMarkup() + ", disableNotification=" + this.isDisableNotification() + ", caption=" + this.getCaption() + ")";
    }

    private SendableVoiceMessage(@NonNull InputFile voice, int duration, long replyTo, ReplyMarkup replyMarkup, boolean disableNotification, String caption) {
        if (voice == null) {
            throw new NullPointerException("voice");
        }
        this.voice = voice;
        this.duration = duration;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
        this.caption = caption;
    }

    @NonNull
    public InputFile getVoice() {
        return this.voice;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public long getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public String getCaption() {
        return this.caption;
    }

    public static class SendableVoiceMessageBuilder {
        private InputFile voice;
        private int duration;
        private long replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;
        private String caption;

        SendableVoiceMessageBuilder() {
        }

        public SendableVoiceMessageBuilder voice(InputFile voice) {
            this.voice = voice;
            return this;
        }

        public SendableVoiceMessageBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public SendableVoiceMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0L;
            return this;
        }

        public SendableVoiceMessageBuilder replyTo(long replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableVoiceMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableVoiceMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableVoiceMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendableVoiceMessage build() {
            return new SendableVoiceMessage(this.voice, this.duration, this.replyTo, this.replyMarkup, this.disableNotification, this.caption);
        }

        public String toString() {
            return "SendableVoiceMessage.SendableVoiceMessageBuilder(voice=" + this.voice + ", duration=" + this.duration + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ", disableNotification=" + this.disableNotification + ", caption=" + this.caption + ")";
        }
    }
}

