/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.event.chat.message;

import java.util.Arrays;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.event.chat.message.TextMessageReceivedEvent;

public class CommandMessageReceivedEvent
extends TextMessageReceivedEvent {
    private final String[] args;
    private final String argsString;
    private final String command;
    private final boolean botMentioned;

    public CommandMessageReceivedEvent(Message message) {
        super(message);
        String[] commandSections = this.getContent().getContent().substring(1).split(" ")[0].split("@");
        this.command = commandSections[0];
        this.botMentioned = commandSections.length >= 1;
        int argsStart = this.getContent().getContent().indexOf(" ");
        if (argsStart != -1) {
            this.argsString = this.getContent().getContent().substring(argsStart).trim();
            this.args = this.argsString.split(" ");
        } else {
            this.args = new String[0];
            this.argsString = "";
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getArgsString() {
        return this.argsString;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isBotMentioned() {
        return this.botMentioned;
    }

    @Override
    public String toString() {
        return "CommandMessageReceivedEvent(args=" + Arrays.deepToString(this.getArgs()) + ", argsString=" + this.getArgsString() + ", command=" + this.getCommand() + ", botMentioned=" + this.isBotMentioned() + ")";
    }
}

