/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.extensions;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.extensions.Extension;

public enum Extensions {
    INSTANCE;

    private final Map<Class<?>, Extension.Provider<? extends Extension>> providers = new HashMap();

    public static <T extends Extension, U extends T> void register(Class<T> cls, Extension.Provider<U> provider) {
        provider = CachedExtensionProvider.wrap(provider);
        Extensions.INSTANCE.providers.put(cls, provider);
    }

    public static <T extends Extension> T get(TelegramBot bot, Class<T> cls) {
        Extension.Provider provider = Extensions.INSTANCE.providers.get(cls);
        if (provider == null) {
            Extension.Provider defaultProvider;
            Extension.DefaultProvider def = cls.getAnnotation(Extension.DefaultProvider.class);
            if (def == null) {
                throw new IllegalArgumentException("No extension found for type " + cls.getName() + ", and no default implementation was provided.");
            }
            try {
                Class<? extends Extension.Provider> extensionFactory = def.value();
                defaultProvider = extensionFactory.newInstance();
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("No provider was found for extension " + cls.getName() + ", and the default implementation did not have a constructor which accepts a TelegramBot instance", ex);
            }
            provider = Extensions.INSTANCE.providers.computeIfAbsent(cls, $ -> CachedExtensionProvider.wrap(defaultProvider));
        }
        return (T)((Extension)cls.cast(provider.create(bot)));
    }

    private static class CachedExtensionProvider<T extends Extension>
    implements Extension.Provider<T> {
        private final Extension.Provider<T> original;
        private Map<TelegramBot, T> extension;

        private CachedExtensionProvider(Extension.Provider<T> original) {
            this.original = original;
            this.extension = new WeakHashMap<TelegramBot, T>();
        }

        @Override
        public T create(TelegramBot bot) {
            return (T)this.extension.computeIfAbsent(bot, this.original::create);
        }

        private static <T extends Extension> CachedExtensionProvider<T> wrap(Extension.Provider<T> original) {
            return original instanceof CachedExtensionProvider ? (CachedExtensionProvider<T>)original : new CachedExtensionProvider<T>(original);
        }
    }
}

