/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.games;

import lombok.NonNull;

public class SendableGameScore {
    @NonNull
    private final Integer userId;
    @NonNull
    private final Long score;
    private final boolean force;
    private final boolean disableEditMessage;
    private final Long chatId;
    private final Integer messageId;
    private final String inlineMessageId;

    public static SendableGameScoreBuilder builder() {
        return new SendableGameScoreBuilder();
    }

    public String toString() {
        return "SendableGameScore(userId=" + this.getUserId() + ", score=" + this.getScore() + ", force=" + this.isForce() + ", disableEditMessage=" + this.isDisableEditMessage() + ", chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ")";
    }

    private SendableGameScore(@NonNull Integer userId, @NonNull Long score, boolean force, boolean disableEditMessage, Long chatId, Integer messageId, String inlineMessageId) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (score == null) {
            throw new NullPointerException("score");
        }
        this.userId = userId;
        this.score = score;
        this.force = force;
        this.disableEditMessage = disableEditMessage;
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
    }

    @NonNull
    public Integer getUserId() {
        return this.userId;
    }

    @NonNull
    public Long getScore() {
        return this.score;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isDisableEditMessage() {
        return this.disableEditMessage;
    }

    public Long getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public static class SendableGameScoreBuilder {
        private Integer userId;
        private Long score;
        private boolean force;
        private boolean disableEditMessage;
        private Long chatId;
        private Integer messageId;
        private String inlineMessageId;

        SendableGameScoreBuilder() {
        }

        public SendableGameScoreBuilder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public SendableGameScoreBuilder score(Long score) {
            this.score = score;
            return this;
        }

        public SendableGameScoreBuilder force(boolean force) {
            this.force = force;
            return this;
        }

        public SendableGameScoreBuilder disableEditMessage(boolean disableEditMessage) {
            this.disableEditMessage = disableEditMessage;
            return this;
        }

        public SendableGameScoreBuilder chatId(Long chatId, Integer messageId) {
            this.chatId = chatId;
            this.messageId = messageId;
            this.inlineMessageId = null;
            return this;
        }

        public SendableGameScoreBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            this.chatId = null;
            this.messageId = null;
            return this;
        }

        public SendableGameScore build() {
            return new SendableGameScore(this.userId, this.score, this.force, this.disableEditMessage, this.chatId, this.messageId, this.inlineMessageId);
        }

        public String toString() {
            return "SendableGameScore.SendableGameScoreBuilder(userId=" + this.userId + ", score=" + this.score + ", force=" + this.force + ", disableEditMessage=" + this.disableEditMessage + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ")";
        }
    }
}

