/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.updates;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.inline.GameInlineCallbackQuery;
import pro.zackpollard.telegrambot.api.chat.inline.InlineCallbackQuery;
import pro.zackpollard.telegrambot.api.chat.message.GameMessageCallbackQuery;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.MessageCallbackQuery;
import pro.zackpollard.telegrambot.api.chat.message.content.TextContent;
import pro.zackpollard.telegrambot.api.event.chat.CallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.ChannelChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.DeleteGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.GroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.MigrateFromChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.MigrateToChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatTitleEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantJoinGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantLeaveGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.SuperGroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.game.GameInlineCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.game.GameMessageCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineResultChosenEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.AudioMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.CommandMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.ContactMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.DocumentMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.LocationMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageEditReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.PhotoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.StickerMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.TextMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VideoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VoiceMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.internal.event.ListenerRegistryImpl;
import pro.zackpollard.telegrambot.api.internal.updates.UpdateImpl;
import pro.zackpollard.telegrambot.api.updates.Update;
import pro.zackpollard.telegrambot.api.updates.UpdateManager;

public class RequestUpdatesManager
extends UpdateManager {
    private ListenerRegistryImpl eventManager = null;
    private Thread updaterThread = null;
    private boolean getPreviousUpdates = false;

    public RequestUpdatesManager(TelegramBot telegramBot, boolean getPreviousUpdates) {
        super(telegramBot);
        this.getPreviousUpdates = getPreviousUpdates;
    }

    @Override
    public boolean startUpdates() {
        if (this.eventManager == null) {
            this.eventManager = (ListenerRegistryImpl)this.getBotInstance().getEventsManager();
        }
        if (this.updaterThread == null && !this.running) {
            this.updaterThread = new Thread(new UpdaterRunnable(this.getPreviousUpdates));
            this.updaterThread.start();
            return true;
        }
        return false;
    }

    @Override
    public void stopUpdates() {
        this.running = false;
        this.updaterThread.interrupt();
    }

    private class UpdaterRunnable
    implements Runnable {
        private boolean getPreviousUpdates;

        protected UpdaterRunnable(boolean getPreviousUpdates) {
            this.getPreviousUpdates = getPreviousUpdates;
        }

        @Override
        public void run() {
            RequestUpdatesManager.this.running = true;
            int offset = 0;
            while (RequestUpdatesManager.this.running) {
                HttpResponse response = null;
                try {
                    response = Unirest.post((String)(RequestUpdatesManager.this.getBotInstance().getBotAPIUrl() + "getUpdates")).field("offset", (Object)(offset + 1), "application/json; charset=utf8;").field("timeout", (Object)10).asString();
                }
                catch (UnirestException e) {
                    System.err.println("There was a connection error when trying to retrieve updates, waiting for 1 second and then trying again.");
                    System.err.println(e.getLocalizedMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (JSONException e) {
                    System.err.println("There was a JSON error, suspected API error, waiting for 1 second and then trying again.");
                    System.err.println(e.getMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (response != null && response.getStatus() == 200) {
                    JSONObject jsonResponse;
                    try {
                        jsonResponse = new JSONObject((String)response.getBody());
                    }
                    catch (JSONException e) {
                        System.err.println("API didn't return a JSON response. Response content was: " + (String)response.getBody());
                        continue;
                    }
                    if (jsonResponse.getBoolean("ok")) {
                        JSONArray updates = jsonResponse.getJSONArray("result");
                        if (updates.length() != 0) {
                            offset = updates.getJSONObject(updates.length() - 1).getInt("update_id");
                        }
                        if (!this.getPreviousUpdates) {
                            if (updates.length() >= 100) continue;
                            this.getPreviousUpdates = true;
                            continue;
                        }
                        for (int i = 0; i < updates.length(); ++i) {
                            Update update = UpdateImpl.createUpdate(updates.getJSONObject(i), RequestUpdatesManager.this.getBotInstance());
                            try {
                                switch (update.getType()) {
                                    case MESSAGE: 
                                    case CHANNEL_POST: {
                                        Message message = update.getType() == Update.UpdateType.MESSAGE ? update.getMessage() : update.getChannelPost();
                                        MessageEvent event = new MessageReceivedEvent(message);
                                        RequestUpdatesManager.this.eventManager.callEvent(event);
                                        boolean isCancelled = event.isCancelled();
                                        boolean hasEvent = true;
                                        switch (message.getContent().getType()) {
                                            case AUDIO: {
                                                event = new AudioMessageReceivedEvent(message);
                                                break;
                                            }
                                            case CONTACT: {
                                                event = new ContactMessageReceivedEvent(message);
                                                break;
                                            }
                                            case DELETE_CHAT_PHOTO: {
                                                event = new DeleteGroupChatPhotoEvent(message);
                                                break;
                                            }
                                            case DOCUMENT: {
                                                event = new DocumentMessageReceivedEvent(message);
                                                break;
                                            }
                                            case LOCATION: {
                                                event = new LocationMessageReceivedEvent(message);
                                                break;
                                            }
                                            case NEW_CHAT_TITLE: {
                                                event = new NewGroupChatTitleEvent(message);
                                                break;
                                            }
                                            case NEW_CHAT_PARTICIPANT: {
                                                event = new ParticipantJoinGroupChatEvent(message);
                                                break;
                                            }
                                            case PHOTO: {
                                                event = new PhotoMessageReceivedEvent(message);
                                                break;
                                            }
                                            case STICKER: {
                                                event = new StickerMessageReceivedEvent(message);
                                                break;
                                            }
                                            case TEXT: {
                                                if (((TextContent)message.getContent()).getContent().startsWith("/")) {
                                                    event = new CommandMessageReceivedEvent(message);
                                                    break;
                                                }
                                                event = new TextMessageReceivedEvent(message);
                                                break;
                                            }
                                            case VIDEO: {
                                                event = new VideoMessageReceivedEvent(message);
                                                break;
                                            }
                                            case VOICE: {
                                                event = new VoiceMessageReceivedEvent(message);
                                                break;
                                            }
                                            case GROUP_CHAT_CREATED: {
                                                event = new GroupChatCreatedEvent(message);
                                                break;
                                            }
                                            case LEFT_CHAT_PARTICIPANT: {
                                                event = new ParticipantLeaveGroupChatEvent(message);
                                                break;
                                            }
                                            case NEW_CHAT_PHOTO: {
                                                event = new NewGroupChatPhotoEvent(message);
                                                break;
                                            }
                                            case CHANNEL_CHAT_CREATED: {
                                                event = new ChannelChatCreatedEvent(message);
                                                break;
                                            }
                                            case MIGRATE_FROM_CHAT_ID: {
                                                event = new MigrateFromChatEvent(message);
                                                break;
                                            }
                                            case MIGRATE_TO_CHAT_ID: {
                                                event = new MigrateToChatEvent(message);
                                                break;
                                            }
                                            case SUPER_GROUP_CHAT_CREATED: {
                                                event = new SuperGroupChatCreatedEvent(message);
                                                break;
                                            }
                                            default: {
                                                hasEvent = false;
                                            }
                                        }
                                        if (!hasEvent) break;
                                        event.setCancelled(isCancelled);
                                        RequestUpdatesManager.this.eventManager.callEvent(event);
                                        break;
                                    }
                                    case EDITED_MESSAGE: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new MessageEditReceivedEvent(update.getEditedMessage()));
                                        break;
                                    }
                                    case EDITED_CHANNEL_POST: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new MessageEditReceivedEvent(update.getEditedMessage()));
                                        break;
                                    }
                                    case INLINE_QUERY: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new InlineQueryReceivedEvent(update.getInlineQuery()));
                                        break;
                                    }
                                    case CHOSEN_INLINE_RESULT: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new InlineResultChosenEvent(update.getChosenInlineResult()));
                                        break;
                                    }
                                    case CALLBACK_QUERY: {
                                        CallbackQueryReceivedEvent event = new CallbackQueryReceivedEvent(update.getCallbackQuery());
                                        RequestUpdatesManager.this.eventManager.callEvent(event);
                                        boolean isCancelled = event.isCancelled();
                                        boolean hasEvent = true;
                                        switch (update.getCallbackQuery().getType()) {
                                            case MESSAGE: {
                                                event = new MessageCallbackQueryReceivedEvent((MessageCallbackQuery)update.getCallbackQuery());
                                                break;
                                            }
                                            case INLINE_MESSAGE: {
                                                event = new InlineCallbackQueryReceivedEvent((InlineCallbackQuery)update.getCallbackQuery());
                                                break;
                                            }
                                            case MESSAGE_GAME: {
                                                event = new GameMessageCallbackQueryReceivedEvent((GameMessageCallbackQuery)update.getCallbackQuery());
                                                break;
                                            }
                                            case INLINE_GAME: {
                                                event = new GameInlineCallbackQueryReceivedEvent((GameInlineCallbackQuery)update.getCallbackQuery());
                                                break;
                                            }
                                            default: {
                                                hasEvent = false;
                                            }
                                        }
                                        if (!hasEvent) break;
                                        event.setCancelled(isCancelled);
                                        RequestUpdatesManager.this.eventManager.callEvent(event);
                                        break;
                                    }
                                }
                                continue;
                            }
                            catch (Exception e) {
                                System.err.println("An error occurred during an event, check the stacktrace below for a more detailed error.");
                                e.printStackTrace();
                            }
                        }
                    } else {
                        System.err.println("The API returned the following error: " + jsonResponse.getString("description"));
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

