/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.keyboards;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkupType;
import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboard;
import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardButton;

public class InlineKeyboardMarkup
implements InlineKeyboard {
    private final List<List<InlineKeyboardButton>> inline_keyboard;

    private InlineKeyboardMarkup(InlineKeyboardMarkupBuilder builder) {
        this.inline_keyboard = builder.inline_keyboard;
    }

    public static InlineKeyboardMarkupBuilder builder() {
        return new InlineKeyboardMarkupBuilder();
    }

    public List<List<InlineKeyboardButton>> getButtons() {
        return this.inline_keyboard;
    }

    @Override
    public ReplyMarkupType getType() {
        return ReplyMarkupType.INLINE_KEYBOARD_MARKUP;
    }

    public String toString() {
        return "InlineKeyboardMarkup(inline_keyboard=" + this.inline_keyboard + ")";
    }

    public static class InlineKeyboardMarkupBuilder {
        private final List<List<InlineKeyboardButton>> inline_keyboard = new LinkedList<List<InlineKeyboardButton>>();

        private InlineKeyboardMarkupBuilder() {
        }

        public InlineKeyboardMarkupBuilder addRow(InlineKeyboardButton ... buttons) {
            return this.addRow(Arrays.asList(buttons));
        }

        public InlineKeyboardMarkupBuilder addRow(List<InlineKeyboardButton> buttons) {
            this.inline_keyboard.add(new LinkedList<InlineKeyboardButton>(buttons));
            return this;
        }

        public InlineKeyboardMarkupBuilder setRow(int row, InlineKeyboardButton ... buttons) {
            return this.setRow(row, Arrays.asList(buttons));
        }

        public InlineKeyboardMarkupBuilder setRow(int row, List<InlineKeyboardButton> buttons) {
            this.inline_keyboard.get(row).clear();
            this.inline_keyboard.get(row).addAll(buttons);
            return this;
        }

        public InlineKeyboardMarkupBuilder setCell(int row, int column, InlineKeyboardButton button) {
            this.inline_keyboard.get(row).set(column, button);
            return this;
        }

        public InlineKeyboardMarkup build() {
            return new InlineKeyboardMarkup(this);
        }

        public String toString() {
            return "InlineKeyboardMarkup.InlineKeyboardMarkupBuilder(inline_keyboard=" + this.inline_keyboard + ")";
        }
    }
}

