/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.content;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContentType;

public class InputContactMessageContent
implements InputMessageContent {
    @NonNull
    private final String phone_number;
    @NonNull
    private final String first_name;
    private final String last_name;

    public static InputContactMessageContentBuilder builder() {
        return new InputContactMessageContentBuilder();
    }

    @Override
    public InputMessageContentType getType() {
        return InputMessageContentType.CONTACT;
    }

    @NonNull
    public String getPhoneNumber() {
        return this.phone_number;
    }

    @NonNull
    public String getFirstName() {
        return this.first_name;
    }

    public String getLastName() {
        return this.last_name;
    }

    public String toString() {
        return "InputContactMessageContent(phone_number=" + this.phone_number + ", first_name=" + this.first_name + ", last_name=" + this.last_name + ")";
    }

    private InputContactMessageContent(@NonNull String phone_number, @NonNull String first_name, String last_name) {
        if (phone_number == null) {
            throw new NullPointerException("phone_number");
        }
        if (first_name == null) {
            throw new NullPointerException("first_name");
        }
        this.phone_number = phone_number;
        this.first_name = first_name;
        this.last_name = last_name;
    }

    public static class InputContactMessageContentBuilder {
        private String phone_number;
        private String first_name;
        private String last_name;

        InputContactMessageContentBuilder() {
        }

        public InputContactMessageContentBuilder phoneNumber(String phoneNumber) {
            this.phone_number = phoneNumber;
            return this;
        }

        public InputContactMessageContentBuilder firstName(String firstName) {
            this.first_name = firstName;
            return this;
        }

        public InputContactMessageContentBuilder lastName(String lastName) {
            this.last_name = lastName;
            return this;
        }

        public InputContactMessageContent build() {
            return new InputContactMessageContent(this.phone_number, this.first_name, this.last_name);
        }

        public String toString() {
            return "InputContactMessageContent.InputContactMessageContentBuilder(phone_number=" + this.phone_number + ", first_name=" + this.first_name + ", last_name=" + this.last_name + ")";
        }
    }
}

