/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultGame
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.GAME;
    @NonNull
    private final String id;
    @NonNull
    private final String game_short_name;
    private final InlineReplyMarkup reply_markup;

    public static InlineQueryResultGameBuilder builder() {
        return new InlineQueryResultGameBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public String toString() {
        return "InlineQueryResultGame(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", game_short_name=" + this.game_short_name + ", reply_markup=" + this.reply_markup + ")";
    }

    private InlineQueryResultGame(@NonNull String id, @NonNull String game_short_name, InlineReplyMarkup reply_markup) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (game_short_name == null) {
            throw new NullPointerException("game_short_name");
        }
        this.id = id;
        this.game_short_name = game_short_name;
        this.reply_markup = reply_markup;
    }

    public static class InlineQueryResultGameBuilder {
        private String id = Utils.generateRandomString(32);
        private String game_short_name;
        private InlineReplyMarkup reply_markup;

        InlineQueryResultGameBuilder() {
        }

        public InlineQueryResultGameBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultGameBuilder gameShortName(String gameShortName) {
            this.game_short_name = gameShortName;
            return this;
        }

        public InlineQueryResultGameBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultGame build() {
            return new InlineQueryResultGame(this.id, this.game_short_name, this.reply_markup);
        }

        public String toString() {
            return "InlineQueryResultGame.InlineQueryResultGameBuilder(id=" + this.id + ", game_short_name=" + this.game_short_name + ", reply_markup=" + this.reply_markup + ")";
        }
    }
}

