/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableAudioMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final InputFile audio;
    private final int duration;
    private final String performer;
    private final String title;
    private final long replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;
    private final String caption;

    public static SendableAudioMessageBuilder builder() {
        return new SendableAudioMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.AUDIO;
    }

    public String toString() {
        return "SendableAudioMessage(audio=" + this.getAudio() + ", duration=" + this.getDuration() + ", performer=" + this.getPerformer() + ", title=" + this.getTitle() + ", replyTo=" + this.getReplyTo() + ", replyMarkup=" + this.getReplyMarkup() + ", disableNotification=" + this.isDisableNotification() + ", caption=" + this.getCaption() + ")";
    }

    private SendableAudioMessage(@NonNull InputFile audio, int duration, String performer, String title, long replyTo, ReplyMarkup replyMarkup, boolean disableNotification, String caption) {
        if (audio == null) {
            throw new NullPointerException("audio");
        }
        this.audio = audio;
        this.duration = duration;
        this.performer = performer;
        this.title = title;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
        this.caption = caption;
    }

    @NonNull
    public InputFile getAudio() {
        return this.audio;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public long getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public String getCaption() {
        return this.caption;
    }

    public static class SendableAudioMessageBuilder {
        private InputFile audio;
        private int duration;
        private String performer;
        private String title;
        private long replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;
        private String caption;

        SendableAudioMessageBuilder() {
        }

        public SendableAudioMessageBuilder audio(InputFile audio) {
            assert (audio != null);
            this.audio = audio;
            return this;
        }

        public SendableAudioMessageBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public SendableAudioMessageBuilder performer(String performer) {
            this.performer = performer;
            return this;
        }

        public SendableAudioMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SendableAudioMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0L;
            return this;
        }

        public SendableAudioMessageBuilder replyTo(long replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableAudioMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableAudioMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableAudioMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendableAudioMessage build() {
            return new SendableAudioMessage(this.audio, this.duration, this.performer, this.title, this.replyTo, this.replyMarkup, this.disableNotification, this.caption);
        }

        public String toString() {
            return "SendableAudioMessage.SendableAudioMessageBuilder(audio=" + this.audio + ", duration=" + this.duration + ", performer=" + this.performer + ", title=" + this.title + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ", disableNotification=" + this.disableNotification + ", caption=" + this.caption + ")";
        }
    }
}

