/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum FileExtension {
    UNKNOWN("", new String[0]),
    JPG("jpg", "image/jpeg"),
    PNG("png", "image/png"),
    GIF("gif", "image/gif"),
    MP4("mp4", "video/mp4"),
    MOV("mov", "video/quicktime"),
    MP3("mp3", "audio/mp3"),
    AVI("avi", "video/avi"),
    MKV("mkv", "video/x-matroska");

    private final String extension;
    private final String[] mimeTypes;
    private static final Map<String, FileExtension> byMimeType;

    private FileExtension(String extension, String ... mimeTypes) {
        this.extension = extension;
        this.mimeTypes = mimeTypes;
    }

    public static String getByMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        int index = mimeType.indexOf(43);
        if (index > 0) {
            mimeType = mimeType.substring(0, index);
        }
        return Optional.ofNullable(byMimeType.get(mimeType)).map(FileExtension::getExtension).orElse(null);
    }

    public String getExtension() {
        return this.extension;
    }

    public String[] getMimeTypes() {
        return this.mimeTypes;
    }

    static {
        HashMap<String, FileExtension> map = new HashMap<String, FileExtension>();
        for (FileExtension ext : FileExtension.values()) {
            for (String mimeType : ext.getMimeTypes()) {
                map.put(mimeType, ext);
            }
        }
        byMimeType = Collections.unmodifiableMap(map);
    }
}

