/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.edit;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.edit.EditType;
import pro.zackpollard.telegrambot.api.chat.edit.EditableMessage;
import pro.zackpollard.telegrambot.api.chat.message.Message;

public class EditableGameScore
implements EditableMessage {
    @NonNull
    private final long userId;
    @NonNull
    private final long score;
    private final long chatId;
    private final long messageId;
    private final String inlineMessageId;
    private final boolean editMessage;

    public static EditableGameScoreBuilder builder() {
        return new EditableGameScoreBuilder();
    }

    @Override
    public EditType getType() {
        return EditType.GAME;
    }

    public String toString() {
        return "EditableGameScore(userId=" + this.getUserId() + ", score=" + this.getScore() + ", chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", editMessage=" + this.isEditMessage() + ")";
    }

    @ConstructorProperties(value={"userId", "score", "chatId", "messageId", "inlineMessageId", "editMessage"})
    private EditableGameScore(@NonNull long userId, @NonNull long score, long chatId, long messageId, String inlineMessageId, boolean editMessage) {
        this.userId = userId;
        this.score = score;
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.editMessage = editMessage;
    }

    @NonNull
    public long getUserId() {
        return this.userId;
    }

    @NonNull
    public long getScore() {
        return this.score;
    }

    public long getChatId() {
        return this.chatId;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public boolean isEditMessage() {
        return this.editMessage;
    }

    public static class EditableGameScoreBuilder {
        private long userId;
        private long score;
        private long chatId;
        private long messageId;
        private String inlineMessageId;
        private boolean editMessage;

        EditableGameScoreBuilder() {
        }

        public EditableGameScoreBuilder userId(long userId) {
            this.userId = userId;
            return this;
        }

        public EditableGameScoreBuilder score(long score) {
            this.score = score;
            return this;
        }

        public EditableGameScoreBuilder message(Message message) {
            switch (message.getChat().getType()) {
                case GROUP: 
                case SUPERGROUP: 
                case PRIVATE: {
                    this.message(Long.valueOf(message.getChat().getId()), message.getMessageId());
                    break;
                }
                default: {
                    System.err.println("EditableGameScoreBuilder#message(Message) was called using a message from a channel. This is not supported by the API.");
                }
            }
            return this;
        }

        public EditableGameScoreBuilder message(long chatId, long messageId) {
            this.chatId = chatId;
            this.messageId = messageId;
            this.inlineMessageId = null;
            return this;
        }

        public EditableGameScoreBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        public EditableGameScoreBuilder editMessage(boolean editMessage) {
            this.editMessage = editMessage;
            return this;
        }

        public EditableGameScore build() {
            return new EditableGameScore(this.userId, this.score, this.chatId, this.messageId, this.inlineMessageId, this.editMessage);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.edit.EditableGameScore.EditableGameScoreBuilder(userId=" + this.userId + ", score=" + this.score + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", editMessage=" + this.editMessage + ")";
        }
    }
}

