/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;

public class InlineQueryResponse {
    @NonNull
    private final List<InlineQueryResult> results;
    private final Integer cache_time;
    private final boolean is_personal;
    private final String next_offset;
    private final String switch_pm_text;
    private final String switch_pm_parameter;

    public static InlineQueryResponseBuilder builder() {
        return new InlineQueryResponseBuilder();
    }

    @NonNull
    public List<InlineQueryResult> getResults() {
        return this.results;
    }

    public Integer getCacheTime() {
        return this.cache_time;
    }

    public boolean isPersonal() {
        return this.is_personal;
    }

    public String getNextOffset() {
        return this.next_offset;
    }

    public String getSwitchPmText() {
        return this.switch_pm_text;
    }

    public String getSwitchPmParameter() {
        return this.switch_pm_parameter;
    }

    public String toString() {
        return "InlineQueryResponse(results=" + this.getResults() + ", cache_time=" + this.cache_time + ", is_personal=" + this.is_personal + ", next_offset=" + this.next_offset + ", switch_pm_text=" + this.switch_pm_text + ", switch_pm_parameter=" + this.switch_pm_parameter + ")";
    }

    @ConstructorProperties(value={"results", "cache_time", "is_personal", "next_offset", "switch_pm_text", "switch_pm_parameter"})
    private InlineQueryResponse(@NonNull List<InlineQueryResult> results, Integer cache_time, boolean is_personal, String next_offset, String switch_pm_text, String switch_pm_parameter) {
        if (results == null) {
            throw new NullPointerException("results");
        }
        this.results = results;
        this.cache_time = cache_time;
        this.is_personal = is_personal;
        this.next_offset = next_offset;
        this.switch_pm_text = switch_pm_text;
        this.switch_pm_parameter = switch_pm_parameter;
    }

    public static class InlineQueryResponseBuilder {
        private List<InlineQueryResult> results;
        private Integer cache_time = 300;
        private boolean is_personal = false;
        private String next_offset = "";
        private String switch_pm_text;
        private String switch_pm_parameter;

        InlineQueryResponseBuilder() {
        }

        public InlineQueryResponseBuilder results(List<InlineQueryResult> results) {
            this.results = results;
            return this;
        }

        public InlineQueryResponseBuilder results(InlineQueryResult ... results) {
            this.results = Arrays.asList(results);
            return this;
        }

        public InlineQueryResponseBuilder cacheTime(Integer cacheTime) {
            this.cache_time = cacheTime;
            return this;
        }

        public InlineQueryResponseBuilder isPersonal(boolean isPersonal) {
            this.is_personal = isPersonal;
            return this;
        }

        public InlineQueryResponseBuilder nextOffset(String nextOffset) {
            this.next_offset = nextOffset;
            return this;
        }

        public InlineQueryResponseBuilder switchPMText(String switchPmText) {
            this.switch_pm_text = switchPmText;
            return this;
        }

        public InlineQueryResponseBuilder switchPMParameter(String switchPmParameter) {
            this.switch_pm_parameter = switchPmParameter;
            return this;
        }

        public InlineQueryResponse build() {
            return new InlineQueryResponse(this.results, this.cache_time, this.is_personal, this.next_offset, this.switch_pm_text, this.switch_pm_parameter);
        }

        public String toString() {
            return "InlineQueryResponse.InlineQueryResponseBuilder(results=" + this.results + ", cache_time=" + this.cache_time + ", is_personal=" + this.is_personal + ", next_offset=" + this.next_offset + ", switch_pm_text=" + this.switch_pm_text + ", switch_pm_parameter=" + this.switch_pm_parameter + ")";
        }
    }
}

