/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.content;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContentType;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;

public class InputTextMessageContent
implements InputMessageContent {
    @NonNull
    private final String message_text;
    private final ParseMode parse_mode;
    private final boolean disable_web_page_preview;

    public static InputTextMessageContentBuilder builder() {
        return new InputTextMessageContentBuilder();
    }

    @NonNull
    public String getMessageText() {
        return this.message_text;
    }

    public ParseMode getParseMode() {
        return this.parse_mode;
    }

    public boolean isDisableWebPagePreview() {
        return this.disable_web_page_preview;
    }

    @Override
    public InputMessageContentType getType() {
        return InputMessageContentType.TEXT;
    }

    public String toString() {
        return "InputTextMessageContent(message_text=" + this.message_text + ", parse_mode=" + (Object)((Object)this.parse_mode) + ", disable_web_page_preview=" + this.disable_web_page_preview + ")";
    }

    @ConstructorProperties(value={"message_text", "parse_mode", "disable_web_page_preview"})
    private InputTextMessageContent(@NonNull String message_text, ParseMode parse_mode, boolean disable_web_page_preview) {
        if (message_text == null) {
            throw new NullPointerException("message_text");
        }
        this.message_text = message_text;
        this.parse_mode = parse_mode;
        this.disable_web_page_preview = disable_web_page_preview;
    }

    public static class InputTextMessageContentBuilder {
        private String message_text;
        private ParseMode parse_mode = ParseMode.NONE;
        private boolean disable_web_page_preview = false;

        InputTextMessageContentBuilder() {
        }

        public InputTextMessageContentBuilder messageText(String messageText) {
            this.message_text = messageText;
            return this;
        }

        public InputTextMessageContentBuilder parseMode(ParseMode parseMode) {
            this.parse_mode = parseMode;
            return this;
        }

        public InputTextMessageContentBuilder disableWebPagePreview(boolean disableWebPagePreview) {
            this.disable_web_page_preview = disableWebPagePreview;
            return this;
        }

        public InputTextMessageContent build() {
            return new InputTextMessageContent(this.message_text, this.parse_mode, this.disable_web_page_preview);
        }

        public String toString() {
            return "InputTextMessageContent.InputTextMessageContentBuilder(message_text=" + this.message_text + ", parse_mode=" + (Object)((Object)this.parse_mode) + ", disable_web_page_preview=" + this.disable_web_page_preview + ")";
        }
    }
}

