/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.beans.ConstructorProperties;
import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultArticle
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.ARTICLE;
    @NonNull
    private final String id;
    @NonNull
    private final String title;
    @NonNull
    private final InputMessageContent input_message_content;
    private final InlineReplyMarkup reply_markup;
    private final URL url;
    private final boolean hide_url;
    private final String description;
    private final URL thumb_url;
    private final int thumb_width;
    private final int thumb_height;

    public static InlineQueryResultArticleBuilder builder() {
        return new InlineQueryResultArticleBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public InputMessageContent getContent() {
        return this.input_message_content;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isHideUrl() {
        return this.hide_url;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public int getThumbWidth() {
        return this.thumb_width;
    }

    public int getThumbHeight() {
        return this.thumb_height;
    }

    public String toString() {
        return "InlineQueryResultArticle(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", title=" + this.getTitle() + ", input_message_content=" + this.input_message_content + ", reply_markup=" + this.reply_markup + ", url=" + this.getUrl() + ", hide_url=" + this.hide_url + ", description=" + this.getDescription() + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
    }

    @ConstructorProperties(value={"id", "title", "input_message_content", "reply_markup", "url", "hide_url", "description", "thumb_url", "thumb_width", "thumb_height"})
    private InlineQueryResultArticle(@NonNull String id, @NonNull String title, @NonNull InputMessageContent input_message_content, InlineReplyMarkup reply_markup, URL url, boolean hide_url, String description, URL thumb_url, int thumb_width, int thumb_height) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (input_message_content == null) {
            throw new NullPointerException("input_message_content");
        }
        this.id = id;
        this.title = title;
        this.input_message_content = input_message_content;
        this.reply_markup = reply_markup;
        this.url = url;
        this.hide_url = hide_url;
        this.description = description;
        this.thumb_url = thumb_url;
        this.thumb_width = thumb_width;
        this.thumb_height = thumb_height;
    }

    public static class InlineQueryResultArticleBuilder {
        private String id = Utils.generateRandomString(32);
        private String title;
        private InputMessageContent input_message_content;
        private InlineReplyMarkup reply_markup;
        private URL url;
        private boolean hide_url;
        private String description;
        private URL thumb_url;
        private int thumb_width;
        private int thumb_height;

        InlineQueryResultArticleBuilder() {
        }

        public InlineQueryResultArticleBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultArticleBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultArticleBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultArticleBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultArticleBuilder url(URL url) {
            this.url = url;
            return this;
        }

        public InlineQueryResultArticleBuilder hideUrl(boolean hideUrl) {
            this.hide_url = hideUrl;
            return this;
        }

        public InlineQueryResultArticleBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InlineQueryResultArticleBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultArticleBuilder thumbWidth(int thumbWidth) {
            this.thumb_width = thumbWidth;
            return this;
        }

        public InlineQueryResultArticleBuilder thumbHeight(int thumbHeight) {
            this.thumb_height = thumbHeight;
            return this;
        }

        public InlineQueryResultArticle build() {
            return new InlineQueryResultArticle(this.id, this.title, this.input_message_content, this.reply_markup, this.url, this.hide_url, this.description, this.thumb_url, this.thumb_width, this.thumb_height);
        }

        public String toString() {
            return "InlineQueryResultArticle.InlineQueryResultArticleBuilder(id=" + this.id + ", title=" + this.title + ", input_message_content=" + this.input_message_content + ", reply_markup=" + this.reply_markup + ", url=" + this.url + ", hide_url=" + this.hide_url + ", description=" + this.description + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
        }
    }
}

