/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.beans.ConstructorProperties;
import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultContact
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.CONTACT;
    @NonNull
    private final String id;
    @NonNull
    private final String phone_number;
    @NonNull
    private final String first_name;
    private final String last_name;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;
    private final URL thumb_url;
    private final Integer thumb_width;
    private final Integer thumb_height;

    public static InlineQueryResultContactBuilder builder() {
        return new InlineQueryResultContactBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getPhoneNumber() {
        return this.phone_number;
    }

    @NonNull
    public String getFirstName() {
        return this.first_name;
    }

    public String getLastName() {
        return this.last_name;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public int getThumbWidth() {
        return this.thumb_width;
    }

    public int getThumbHeight() {
        return this.thumb_height;
    }

    public String toString() {
        return "InlineQueryResultContact(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", phone_number=" + this.phone_number + ", first_name=" + this.first_name + ", last_name=" + this.last_name + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
    }

    @ConstructorProperties(value={"id", "phone_number", "first_name", "last_name", "reply_markup", "input_message_content", "thumb_url", "thumb_width", "thumb_height"})
    private InlineQueryResultContact(@NonNull String id, @NonNull String phone_number, @NonNull String first_name, String last_name, InlineReplyMarkup reply_markup, InputMessageContent input_message_content, URL thumb_url, Integer thumb_width, Integer thumb_height) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (phone_number == null) {
            throw new NullPointerException("phone_number");
        }
        if (first_name == null) {
            throw new NullPointerException("first_name");
        }
        this.id = id;
        this.phone_number = phone_number;
        this.first_name = first_name;
        this.last_name = last_name;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
        this.thumb_url = thumb_url;
        this.thumb_width = thumb_width;
        this.thumb_height = thumb_height;
    }

    public static class InlineQueryResultContactBuilder {
        private String id = Utils.generateRandomString(32);
        private String phone_number;
        private String first_name;
        private String last_name;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;
        private URL thumb_url;
        private Integer thumb_width;
        private Integer thumb_height;

        InlineQueryResultContactBuilder() {
        }

        public InlineQueryResultContactBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultContactBuilder phoneNumber(String phoneNumber) {
            this.phone_number = phoneNumber;
            return this;
        }

        public InlineQueryResultContactBuilder firstName(String firstName) {
            this.first_name = firstName;
            return this;
        }

        public InlineQueryResultContactBuilder lastName(String lastName) {
            this.last_name = lastName;
            return this;
        }

        public InlineQueryResultContactBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultContactBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultContactBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultContactBuilder thumbWidth(int thumbWidth) {
            this.thumb_width = thumbWidth;
            return this;
        }

        public InlineQueryResultContactBuilder thumbHeight(int thumbHeight) {
            this.thumb_height = thumbHeight;
            return this;
        }

        public InlineQueryResultContact build() {
            return new InlineQueryResultContact(this.id, this.phone_number, this.first_name, this.last_name, this.reply_markup, this.input_message_content, this.thumb_url, this.thumb_width, this.thumb_height);
        }

        public String toString() {
            return "InlineQueryResultContact.InlineQueryResultContactBuilder(id=" + this.id + ", phone_number=" + this.phone_number + ", first_name=" + this.first_name + ", last_name=" + this.last_name + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
        }
    }
}

