/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.beans.ConstructorProperties;
import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultGif
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.GIF;
    @NonNull
    private final String id;
    @NonNull
    private final URL gif_url;
    private final int gif_width;
    private final int gif_height;
    @NonNull
    private final URL thumb_url;
    private final String title;
    private final String caption;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultGifBuilder builder() {
        return new InlineQueryResultGifBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getGifUrl() {
        return this.gif_url;
    }

    public int getGifWidth() {
        return this.gif_width;
    }

    public int getGifHeight() {
        return this.gif_height;
    }

    @NonNull
    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String toString() {
        return "InlineQueryResultGif(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", gif_url=" + this.gif_url + ", gif_width=" + this.gif_width + ", gif_height=" + this.gif_height + ", thumb_url=" + this.thumb_url + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    @ConstructorProperties(value={"id", "gif_url", "gif_width", "gif_height", "thumb_url", "title", "caption", "reply_markup", "input_message_content"})
    private InlineQueryResultGif(@NonNull String id, @NonNull URL gif_url, int gif_width, int gif_height, @NonNull URL thumb_url, String title, String caption, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (gif_url == null) {
            throw new NullPointerException("gif_url");
        }
        if (thumb_url == null) {
            throw new NullPointerException("thumb_url");
        }
        this.id = id;
        this.gif_url = gif_url;
        this.gif_width = gif_width;
        this.gif_height = gif_height;
        this.thumb_url = thumb_url;
        this.title = title;
        this.caption = caption;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultGifBuilder {
        private String id = Utils.generateRandomString(32);
        private URL gif_url;
        private int gif_width;
        private int gif_height;
        private URL thumb_url;
        private String title;
        private String caption;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultGifBuilder() {
        }

        public InlineQueryResultGifBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultGifBuilder gifUrl(URL gifUrl) {
            this.gif_url = gifUrl;
            return this;
        }

        public InlineQueryResultGifBuilder gifWidth(int gifWidth) {
            this.gif_width = gifWidth;
            return this;
        }

        public InlineQueryResultGifBuilder gifHeight(int gifHeight) {
            this.gif_height = gifHeight;
            return this;
        }

        public InlineQueryResultGifBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultGifBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultGifBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultGifBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultGifBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultGif build() {
            return new InlineQueryResultGif(this.id, this.gif_url, this.gif_width, this.gif_height, this.thumb_url, this.title, this.caption, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultGif.InlineQueryResultGifBuilder(id=" + this.id + ", gif_url=" + this.gif_url + ", gif_width=" + this.gif_width + ", gif_height=" + this.gif_height + ", thumb_url=" + this.thumb_url + ", title=" + this.title + ", caption=" + this.caption + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

