/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.beans.ConstructorProperties;
import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultLocation
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.LOCATION;
    @NonNull
    private final String id;
    @NonNull
    private final Double latitude;
    @NonNull
    private final Double longitude;
    @NonNull
    private final String title;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;
    private final URL thumb_url;
    private final Integer thumb_width;
    private final Integer thumb_height;

    public static InlineQueryResultLocationBuilder builder() {
        return new InlineQueryResultLocationBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public Double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Double getLongitude() {
        return this.longitude;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public int getThumbWidth() {
        return this.thumb_width;
    }

    public int getThumbHeight() {
        return this.thumb_height;
    }

    public String toString() {
        return "InlineQueryResultLocation(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", title=" + this.getTitle() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
    }

    @ConstructorProperties(value={"id", "latitude", "longitude", "title", "reply_markup", "input_message_content", "thumb_url", "thumb_width", "thumb_height"})
    private InlineQueryResultLocation(@NonNull String id, @NonNull Double latitude, @NonNull Double longitude, @NonNull String title, InlineReplyMarkup reply_markup, InputMessageContent input_message_content, URL thumb_url, Integer thumb_width, Integer thumb_height) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
        this.thumb_url = thumb_url;
        this.thumb_width = thumb_width;
        this.thumb_height = thumb_height;
    }

    public static class InlineQueryResultLocationBuilder {
        private String id = Utils.generateRandomString(32);
        private Double latitude;
        private Double longitude;
        private String title;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;
        private URL thumb_url;
        private Integer thumb_width;
        private Integer thumb_height;

        InlineQueryResultLocationBuilder() {
        }

        public InlineQueryResultLocationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultLocationBuilder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public InlineQueryResultLocationBuilder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public InlineQueryResultLocationBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultLocationBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultLocationBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultLocationBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultLocationBuilder thumbWidth(int thumbWidth) {
            this.thumb_width = thumbWidth;
            return this;
        }

        public InlineQueryResultLocationBuilder thumbHeight(int thumbHeight) {
            this.thumb_height = thumbHeight;
            return this;
        }

        public InlineQueryResultLocation build() {
            return new InlineQueryResultLocation(this.id, this.latitude, this.longitude, this.title, this.reply_markup, this.input_message_content, this.thumb_url, this.thumb_width, this.thumb_height);
        }

        public String toString() {
            return "InlineQueryResultLocation.InlineQueryResultLocationBuilder(id=" + this.id + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
        }
    }
}

