/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableGameMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final String gameShortName;
    private final long replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;

    public static SendableGameMessageBuilder builder() {
        return new SendableGameMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.GAME;
    }

    public String toString() {
        return "SendableGameMessage(gameShortName=" + this.getGameShortName() + ", replyTo=" + this.getReplyTo() + ", replyMarkup=" + this.getReplyMarkup() + ", disableNotification=" + this.isDisableNotification() + ")";
    }

    @ConstructorProperties(value={"gameShortName", "replyTo", "replyMarkup", "disableNotification"})
    private SendableGameMessage(@NonNull String gameShortName, long replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        if (gameShortName == null) {
            throw new NullPointerException("gameShortName");
        }
        this.gameShortName = gameShortName;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public String getGameShortName() {
        return this.gameShortName;
    }

    @Override
    public long getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableGameMessageBuilder {
        private String gameShortName;
        private long replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;

        SendableGameMessageBuilder() {
        }

        public SendableGameMessageBuilder gameShortName(String gameShortName) {
            this.gameShortName = gameShortName;
            return this;
        }

        public SendableGameMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0L;
            return this;
        }

        public SendableGameMessageBuilder replyTo(long replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableGameMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableGameMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableGameMessage build() {
            return new SendableGameMessage(this.gameShortName, this.replyTo, this.replyMarkup, this.disableNotification);
        }

        public String toString() {
            return "SendableGameMessage.SendableGameMessageBuilder(gameShortName=" + this.gameShortName + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ", disableNotification=" + this.disableNotification + ")";
        }
    }
}

