/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.games;

import java.beans.ConstructorProperties;
import lombok.NonNull;

public class GameScoreRequest {
    @NonNull
    private final Integer userId;
    private final Long chatId;
    private final Integer messageId;
    private final String inlineMessageId;

    public static GameScoreRequestBuilder builder() {
        return new GameScoreRequestBuilder();
    }

    public String toString() {
        return "GameScoreRequest(userId=" + this.getUserId() + ", chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ")";
    }

    @ConstructorProperties(value={"userId", "chatId", "messageId", "inlineMessageId"})
    private GameScoreRequest(@NonNull Integer userId, Long chatId, Integer messageId, String inlineMessageId) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        this.userId = userId;
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
    }

    @NonNull
    public Integer getUserId() {
        return this.userId;
    }

    public Long getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public static class GameScoreRequestBuilder {
        private Integer userId;
        private Long chatId;
        private Integer messageId;
        private String inlineMessageId;

        GameScoreRequestBuilder() {
        }

        public GameScoreRequestBuilder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public GameScoreRequestBuilder message(Long chatId, Integer messageId) {
            this.chatId = chatId;
            this.messageId = messageId;
            this.inlineMessageId = null;
            return this;
        }

        public GameScoreRequestBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            this.chatId = null;
            this.messageId = null;
            return this;
        }

        public GameScoreRequest build() {
            return new GameScoreRequest(this.userId, this.chatId, this.messageId, this.inlineMessageId);
        }

        public String toString() {
            return "GameScoreRequest.GameScoreRequestBuilder(userId=" + this.userId + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ")";
        }
    }
}

