/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.content.Content;
import pro.zackpollard.telegrambot.api.internal.chat.ChatImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.ContentImpl;
import pro.zackpollard.telegrambot.api.internal.user.UserImpl;
import pro.zackpollard.telegrambot.api.user.User;

public class MessageImpl
implements Message {
    private final JSONObject jsonMessage;
    private final int message_id;
    private final User from;
    private final long date;
    private final Chat chat;
    private final User forward_from;
    private final Chat forward_from_chat;
    private final Integer forward_from_message_id;
    private final Long forward_date;
    private final Message reply_to_message;
    private final Long edit_date;
    private final Content content;
    private final TelegramBot telegramBot;

    private MessageImpl(JSONObject jsonObject, TelegramBot telegramBot) {
        if (!jsonObject.isNull("result")) {
            jsonObject = jsonObject.getJSONObject("result");
        }
        this.jsonMessage = jsonObject;
        this.message_id = jsonObject.getInt("message_id");
        this.from = UserImpl.createUser(jsonObject.optJSONObject("from"));
        this.date = jsonObject.getLong("date");
        this.chat = ChatImpl.createChat(jsonObject.getJSONObject("chat"), telegramBot);
        this.forward_from = UserImpl.createUser(jsonObject.optJSONObject("forward_from"));
        this.forward_from_chat = ChatImpl.createChat(jsonObject.optJSONObject("forward_from_chat"), telegramBot);
        this.forward_from_message_id = jsonObject.optInt("forward_from_message_id");
        this.forward_date = jsonObject.optLong("forward_date");
        this.reply_to_message = MessageImpl.createMessage(jsonObject.optJSONObject("reply_to_message"), telegramBot);
        this.edit_date = jsonObject.optLong("edit_date");
        this.content = ContentImpl.createContent(jsonObject, telegramBot);
        this.telegramBot = telegramBot;
    }

    public static Message createMessage(JSONObject jsonObject, TelegramBot telegramBot) {
        return jsonObject != null ? new MessageImpl(jsonObject, telegramBot) : null;
    }

    @Override
    public long getMessageId() {
        return this.message_id;
    }

    @Override
    public long getTimeStamp() {
        return this.date;
    }

    @Override
    public User getSender() {
        return this.from;
    }

    @Override
    public Chat getChat() {
        return this.chat;
    }

    @Override
    public User getForwardedFrom() {
        return this.forward_from;
    }

    @Override
    public Chat getChatForwardedFrom() {
        return this.forward_from_chat;
    }

    @Override
    public Integer getForwardFromMessageId() {
        return this.forward_from_message_id;
    }

    @Override
    public Long getForwardedDate() {
        return this.forward_date;
    }

    @Override
    public Message getRepliedTo() {
        return this.reply_to_message;
    }

    @Override
    public Long getEditDate() {
        return this.edit_date;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public JSONObject asJson() {
        return this.jsonMessage;
    }

    @Override
    public TelegramBot getBotInstance() {
        return this.telegramBot;
    }
}

