/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message.content.type;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Animation;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.type.PhotoSizeImpl;

public class AnimationImpl
implements Animation {
    private final String file_id;
    private final PhotoSize thumb;
    private final String file_name;
    private final String mime_type;
    private final Integer file_size;

    private AnimationImpl(JSONObject jsonObject) {
        this.file_id = jsonObject.getString("file_id");
        this.thumb = PhotoSizeImpl.createPhotoSize(jsonObject.getJSONObject("thumb"));
        this.file_name = jsonObject.optString("file_name");
        this.mime_type = jsonObject.optString("mime_type");
        this.file_size = jsonObject.optInt("file_size");
    }

    public static Animation createAnimation(JSONObject jsonObject) {
        return jsonObject != null ? new AnimationImpl(jsonObject) : null;
    }

    @Override
    public String getMimeType() {
        return this.mime_type;
    }

    @Override
    public PhotoSize getThumbnail() {
        return this.thumb;
    }

    @Override
    public String getFileId() {
        return this.file_id;
    }

    @Override
    public int getSize() {
        return this.file_size;
    }

    @Override
    public String getFileName() {
        return this.file_name;
    }
}

