/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.event;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import pro.zackpollard.telegrambot.api.event.Cancellable;
import pro.zackpollard.telegrambot.api.event.Event;
import pro.zackpollard.telegrambot.api.event.Listener;
import pro.zackpollard.telegrambot.api.event.ListenerRegistry;
import pro.zackpollard.telegrambot.api.event.chat.CallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.ChannelChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.DeleteGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.GroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatTitleEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantJoinGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantLeaveGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.game.GameInlineCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.game.GameMessageCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineResultChosenEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.AudioMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.CommandMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.ContactMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.DocumentMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.LocationMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageEditReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.PhotoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.StickerMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.TextMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VideoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VoiceMessageReceivedEvent;

public class ListenerRegistryImpl
implements ListenerRegistry {
    private final Map<Class<?>, BiConsumer<Listener, ? extends Event>> invokers = new HashMap<Class<?>, BiConsumer<Listener, ? extends Event>>(){
        {
            this.register(AudioMessageReceivedEvent.class, Listener::onAudioMessageReceived);
            this.register(CommandMessageReceivedEvent.class, Listener::onCommandMessageReceived);
            this.register(ContactMessageReceivedEvent.class, Listener::onContactMessageReceived);
            this.register(DocumentMessageReceivedEvent.class, Listener::onDocumentMessageReceived);
            this.register(LocationMessageReceivedEvent.class, Listener::onLocationMessageReceived);
            this.register(MessageReceivedEvent.class, Listener::onMessageReceived);
            this.register(MessageEditReceivedEvent.class, Listener::onMessageEditReceived);
            this.register(PhotoMessageReceivedEvent.class, Listener::onPhotoMessageReceived);
            this.register(StickerMessageReceivedEvent.class, Listener::onStickerMessageReceived);
            this.register(TextMessageReceivedEvent.class, Listener::onTextMessageReceived);
            this.register(VideoMessageReceivedEvent.class, Listener::onVideoMessageReceived);
            this.register(VoiceMessageReceivedEvent.class, Listener::onVoiceMessageReceived);
            this.register(DeleteGroupChatPhotoEvent.class, Listener::onDeleteGroupChatPhoto);
            this.register(GroupChatCreatedEvent.class, Listener::onGroupChatCreated);
            this.register(ChannelChatCreatedEvent.class, Listener::onChannelChatCreated);
            this.register(NewGroupChatPhotoEvent.class, Listener::onNewGroupChatPhoto);
            this.register(NewGroupChatTitleEvent.class, Listener::onNewGroupChatTitle);
            this.register(ParticipantJoinGroupChatEvent.class, Listener::onParticipantJoinGroupChat);
            this.register(ParticipantLeaveGroupChatEvent.class, Listener::onParticipantLeaveGroupChat);
            this.register(InlineQueryReceivedEvent.class, Listener::onInlineQueryReceived);
            this.register(InlineResultChosenEvent.class, Listener::onInlineResultChosen);
            this.register(CallbackQueryReceivedEvent.class, Listener::onCallbackQueryReceivedEvent);
            this.register(MessageCallbackQueryReceivedEvent.class, Listener::onMessageCallbackQueryReceivedEvent);
            this.register(InlineCallbackQueryReceivedEvent.class, Listener::onInlineCallbackQueryReceivedEvent);
            this.register(GameMessageCallbackQueryReceivedEvent.class, Listener::onGameMessageCallbackQueryReceivedEvent);
            this.register(GameInlineCallbackQueryReceivedEvent.class, Listener::onGameInlineCallbackQueryReceivedEvent);
        }

        private <T extends Event> void register(Class<T> clazz, BiConsumer<Listener, T> invoker) {
            this.put(clazz, invoker);
        }
    };
    private final Map<Class<?>, PrioritisedSet<RegisteredListener>> listenerByContent = new HashMap();

    @Override
    public void register(Listener listener) {
        boolean globalIgnore = Optional.ofNullable(listener.getClass().getAnnotation(Event.Handler.class)).map(Event.Handler::ignoreCancelled).orElse(false);
        Event.Priority globalPriority = Optional.ofNullable(listener.getClass().getAnnotation(Event.Handler.class)).map(Event.Handler::priority).orElse(Event.Priority.NORMAL);
        for (Method m : listener.getClass().getDeclaredMethods()) {
            Class<?>[] classes = m.getParameterTypes();
            if (classes.length != 1) continue;
            PrioritisedSet listeners = this.listenerByContent.computeIfAbsent(classes[0], c -> new PrioritisedSet());
            boolean ignore = Optional.ofNullable(m.getAnnotation(Event.Handler.class)).map(Event.Handler::ignoreCancelled).orElse(globalIgnore);
            Event.Priority priority = Optional.ofNullable(m.getAnnotation(Event.Handler.class)).map(Event.Handler::priority).orElse(globalPriority);
            listeners.add(priority, new RegisteredListener(listener, classes[0], ignore));
        }
    }

    @Override
    public void unregister(Listener listener) {
        for (Method m : listener.getClass().getDeclaredMethods()) {
            Class<?>[] classes = m.getParameterTypes();
            if (classes.length != 1) continue;
            RegisteredListener registeredListener = new RegisteredListener(listener, classes[0], false);
            this.listenerByContent.computeIfPresent(classes[0], (c, s) -> s.remove(registeredListener) && s.size() == 0 ? null : s);
        }
    }

    public void callEvent(Event event) {
        boolean cancellable = event instanceof Cancellable;
        BiConsumer<Listener, ? extends Event> invoker = this.invokers.get(event.getClass());
        this.listenerByContent.getOrDefault(event.getClass(), PrioritisedSet.empty()).forEach(listener -> {
            if (!cancellable || listener.isIgnoreCancelled() || !((Cancellable)((Object)event)).isCancelled()) {
                invoker.accept(listener.getListener(), event);
            }
        });
    }

    private ListenerRegistryImpl() {
    }

    public static ListenerRegistry getNewInstance() {
        return new ListenerRegistryImpl();
    }

    private static class RegisteredListener {
        private final Listener listener;
        private final Class<?> eventType;
        private final boolean ignoreCancelled;

        public int hashCode() {
            return Objects.hash(this.listener, this.eventType);
        }

        public boolean equals(Object obj) {
            return obj instanceof RegisteredListener && Objects.equals(((RegisteredListener)obj).getListener(), this.listener);
        }

        @ConstructorProperties(value={"listener", "eventType", "ignoreCancelled"})
        public RegisteredListener(Listener listener, Class<?> eventType, boolean ignoreCancelled) {
            this.listener = listener;
            this.eventType = eventType;
            this.ignoreCancelled = ignoreCancelled;
        }

        public Listener getListener() {
            return this.listener;
        }

        public Class<?> getEventType() {
            return this.eventType;
        }

        public boolean isIgnoreCancelled() {
            return this.ignoreCancelled;
        }
    }

    private static class PrioritisedSet<E>
    implements Iterable<E> {
        private static final Event.Priority[] PRIORITIES = Event.Priority.values();
        private static final PrioritisedSet EMPTY = new PrioritisedSet();
        private Map<Event.Priority, Set<E>> priorised = new EnumMap<Event.Priority, Set<E>>(Event.Priority.class);
        private Map<E, Event.Priority> byListener = new HashMap<E, Event.Priority>();

        private PrioritisedSet() {
        }

        public void add(Event.Priority p, E e) {
            if (this.byListener.putIfAbsent(e, p) != p) {
                this.priorised.computeIfAbsent(p, $ -> new LinkedHashSet()).add(e);
            }
        }

        public boolean remove(E e) {
            Event.Priority p = this.byListener.remove(e);
            if (p != null) {
                return this.priorised.getOrDefault(e, Collections.emptySet()).remove(e);
            }
            return false;
        }

        public static <E> PrioritisedSet<E> empty() {
            return EMPTY;
        }

        public int size() {
            return this.priorised.values().stream().map(Collection::size).reduce(Integer::sum).orElse(0);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int priorityIndex = 0;
                private Iterator<E> iterator;

                private void findNextIterator() {
                    while (!(this.iterator != null && this.iterator.hasNext() || this.priorityIndex >= PRIORITIES.length)) {
                        this.iterator = priorised.getOrDefault((Object)PRIORITIES[this.priorityIndex++], Collections.emptySet()).iterator();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.findNextIterator();
                    return this.iterator != null && this.iterator.hasNext();
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.iterator.next();
                }
            };
        }
    }
}

