/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.keyboards;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.games.CallbackGame;

public class InlineKeyboardButton {
    @NonNull
    private final String text;
    private final String url;
    private final String callback_data;
    private final String switch_inline_query;
    private final String switch_inline_query_current_chat;
    private final CallbackGame callback_game;

    public static InlineKeyboardButtonBuilder builder() {
        return new InlineKeyboardButtonBuilder();
    }

    public String getText() {
        return this.text;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCallbackData() {
        return this.callback_data;
    }

    public String getSwitchInlineQuery() {
        return this.switch_inline_query;
    }

    public String getSwitchInlineQueryCurrentChat() {
        return this.switch_inline_query_current_chat;
    }

    public CallbackGame getCallbackGame() {
        return this.callback_game;
    }

    public String toString() {
        return "InlineKeyboardButton(text=" + this.getText() + ", url=" + this.getUrl() + ", callback_data=" + this.callback_data + ", switch_inline_query=" + this.switch_inline_query + ", switch_inline_query_current_chat=" + this.switch_inline_query_current_chat + ", callback_game=" + this.callback_game + ")";
    }

    @ConstructorProperties(value={"text", "url", "callback_data", "switch_inline_query", "switch_inline_query_current_chat", "callback_game"})
    private InlineKeyboardButton(@NonNull String text, String url, String callback_data, String switch_inline_query, String switch_inline_query_current_chat, CallbackGame callback_game) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.text = text;
        this.url = url;
        this.callback_data = callback_data;
        this.switch_inline_query = switch_inline_query;
        this.switch_inline_query_current_chat = switch_inline_query_current_chat;
        this.callback_game = callback_game;
    }

    public static class InlineKeyboardButtonBuilder {
        private String text = null;
        private String url = null;
        private String callback_data = null;
        private String switch_inline_query = null;
        private CallbackGame callback_game = null;
        private String switch_inline_query_current_chat = null;

        InlineKeyboardButtonBuilder() {
        }

        public InlineKeyboardButtonBuilder text(String text) {
            this.text = text;
            return this;
        }

        public InlineKeyboardButtonBuilder url(String url) {
            this.url = url;
            this.callback_data = null;
            this.switch_inline_query = null;
            this.callback_game = null;
            this.switch_inline_query_current_chat = null;
            return this;
        }

        public InlineKeyboardButtonBuilder callbackData(String callbackData) {
            this.callback_data = callbackData;
            this.url = null;
            this.switch_inline_query = null;
            this.switch_inline_query_current_chat = null;
            this.callback_game = null;
            return this;
        }

        public InlineKeyboardButtonBuilder switchInlineQuery(String switchInlineQuery) {
            this.switch_inline_query = switchInlineQuery;
            this.url = null;
            this.callback_data = null;
            this.callback_game = null;
            this.switch_inline_query_current_chat = null;
            return this;
        }

        public InlineKeyboardButtonBuilder switchInlineQueryCurrentChat(String switchInlineQueryCurrentChat) {
            this.switch_inline_query_current_chat = switchInlineQueryCurrentChat;
            this.switch_inline_query = null;
            this.url = null;
            this.callback_data = null;
            this.callback_game = null;
            return this;
        }

        public InlineKeyboardButtonBuilder callbackGame(CallbackGame callbackGame) {
            return this;
        }

        public InlineKeyboardButton build() {
            return new InlineKeyboardButton(this.text, this.url, this.callback_data, this.switch_inline_query, this.switch_inline_query_current_chat, this.callback_game);
        }

        public String toString() {
            return "InlineKeyboardButton.InlineKeyboardButtonBuilder(text=" + this.text + ", url=" + this.url + ", callback_data=" + this.callback_data + ", switch_inline_query=" + this.switch_inline_query + ", callback_game=" + this.callback_game + ", switch_inline_query_current_chat=" + this.switch_inline_query_current_chat + ")";
        }
    }
}

