/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.keyboards;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkupType;
import pro.zackpollard.telegrambot.api.keyboards.Keyboard;
import pro.zackpollard.telegrambot.api.keyboards.KeyboardButton;

public class ReplyKeyboardMarkup
implements Keyboard {
    private final List<List<KeyboardButton>> keyboard;
    private final boolean resize_keyboard;
    private final boolean one_time_keyboard;
    private boolean selective;

    private ReplyKeyboardMarkup(ReplyKeyboardMarkupBuilder builder) {
        this.keyboard = builder.keyboard;
        this.resize_keyboard = builder.resize_keyboard;
        this.one_time_keyboard = builder.one_time_keyboard;
        this.selective = builder.selective;
    }

    public static ReplyKeyboardMarkupBuilder builder() {
        return new ReplyKeyboardMarkupBuilder();
    }

    public List<List<KeyboardButton>> getButtons() {
        return this.keyboard;
    }

    public boolean getResizeKeyboard() {
        return this.resize_keyboard;
    }

    public boolean getOneTime() {
        return this.one_time_keyboard;
    }

    public boolean getSelective() {
        return this.selective;
    }

    @Override
    public ReplyMarkupType getType() {
        return ReplyMarkupType.KEYBOARD_MARKUP;
    }

    public String toString() {
        return "ReplyKeyboardMarkup(keyboard=" + this.keyboard + ", resize_keyboard=" + this.resize_keyboard + ", one_time_keyboard=" + this.one_time_keyboard + ", selective=" + this.getSelective() + ")";
    }

    public static class ReplyKeyboardMarkupBuilder {
        private final List<List<KeyboardButton>> keyboard = new LinkedList<List<KeyboardButton>>();
        private boolean resize_keyboard = false;
        private boolean one_time_keyboard = false;
        private boolean selective = false;

        private ReplyKeyboardMarkupBuilder() {
        }

        public ReplyKeyboardMarkupBuilder addRow(KeyboardButton ... buttons) {
            return this.addRow(Arrays.asList(buttons));
        }

        public ReplyKeyboardMarkupBuilder addRow(List<KeyboardButton> buttons) {
            this.keyboard.add(new LinkedList<KeyboardButton>(buttons));
            return this;
        }

        public ReplyKeyboardMarkupBuilder setRow(int row, KeyboardButton ... buttons) {
            return this.setRow(row, Arrays.asList(buttons));
        }

        public ReplyKeyboardMarkupBuilder setRow(int row, List<KeyboardButton> buttons) {
            this.keyboard.get(row).clear();
            this.keyboard.get(row).addAll(buttons);
            return this;
        }

        public ReplyKeyboardMarkupBuilder setCell(int row, int column, KeyboardButton button) {
            this.keyboard.get(row).set(column, button);
            return this;
        }

        public ReplyKeyboardMarkupBuilder resize(boolean resize) {
            this.resize_keyboard = resize;
            return this;
        }

        public ReplyKeyboardMarkupBuilder oneTime(boolean oneTime) {
            this.one_time_keyboard = oneTime;
            return this;
        }

        public ReplyKeyboardMarkupBuilder selective(boolean selective) {
            this.selective = selective;
            return this;
        }

        public ReplyKeyboardMarkup build() {
            return new ReplyKeyboardMarkup(this);
        }

        public String toString() {
            return "ReplyKeyboardMarkup.ReplyKeyboardMarkupBuilder(keyboard=" + this.keyboard + ", resize_keyboard=" + this.resize_keyboard + ", one_time_keyboard=" + this.one_time_keyboard + ", selective=" + this.selective + ")";
        }
    }
}

