/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultCached;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultCachedPhoto
implements InlineQueryResultCached {
    private final InlineQueryResultType type = InlineQueryResultType.PHOTO;
    @NonNull
    private final String id;
    @NonNull
    private final String photo_file_id;
    private final String title;
    private final String description;
    private final String caption;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultCachedPhotoBuilder builder() {
        return new InlineQueryResultCachedPhotoBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getPhotoFileId() {
        return this.photo_file_id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String getDescription() {
        return this.description;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public String toString() {
        return "InlineQueryResultCachedPhoto(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", photo_file_id=" + this.photo_file_id + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", caption=" + this.getCaption() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    @ConstructorProperties(value={"id", "photo_file_id", "title", "description", "caption", "reply_markup", "input_message_content"})
    private InlineQueryResultCachedPhoto(@NonNull String id, @NonNull String photo_file_id, String title, String description, String caption, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (photo_file_id == null) {
            throw new NullPointerException("photo_file_id");
        }
        this.id = id;
        this.photo_file_id = photo_file_id;
        this.title = title;
        this.description = description;
        this.caption = caption;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultCachedPhotoBuilder {
        private String id = Utils.generateRandomString(32);
        private String photo_file_id;
        private String title;
        private String description;
        private String caption;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultCachedPhotoBuilder() {
        }

        public InlineQueryResultCachedPhotoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder photoFileId(String photoFileId) {
            this.photo_file_id = photoFileId;
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultCachedPhoto build() {
            return new InlineQueryResultCachedPhoto(this.id, this.photo_file_id, this.title, this.description, this.caption, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultCachedPhoto.InlineQueryResultCachedPhotoBuilder(id=" + this.id + ", photo_file_id=" + this.photo_file_id + ", title=" + this.title + ", description=" + this.description + ", caption=" + this.caption + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

