/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.beans.ConstructorProperties;
import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultVideo
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.VIDEO;
    @NonNull
    private final String id;
    @NonNull
    private final URL video_url;
    @NonNull
    private final String mime_type;
    @NonNull
    private final URL thumb_url;
    private final int video_width;
    private final int video_height;
    @NonNull
    private final String title;
    private final String caption;
    private final int video_duration;
    private final String description;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultVideoBuilder builder() {
        return new InlineQueryResultVideoBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getVideoUrl() {
        return this.video_url;
    }

    @NonNull
    public String getMimeType() {
        return this.mime_type;
    }

    @NonNull
    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public int getVideoWidth() {
        return this.video_width;
    }

    public int getVideoHeight() {
        return this.video_height;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public int getVideoDuration() {
        return this.video_duration;
    }

    public String getDescription() {
        return this.description;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String toString() {
        return "InlineQueryResultVideo(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", video_url=" + this.video_url + ", mime_type=" + this.mime_type + ", thumb_url=" + this.thumb_url + ", video_width=" + this.video_width + ", video_height=" + this.video_height + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", video_duration=" + this.video_duration + ", description=" + this.getDescription() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    @ConstructorProperties(value={"id", "video_url", "mime_type", "thumb_url", "video_width", "video_height", "title", "caption", "video_duration", "description", "reply_markup", "input_message_content"})
    private InlineQueryResultVideo(@NonNull String id, @NonNull URL video_url, @NonNull String mime_type, @NonNull URL thumb_url, int video_width, int video_height, @NonNull String title, String caption, int video_duration, String description, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (video_url == null) {
            throw new NullPointerException("video_url");
        }
        if (mime_type == null) {
            throw new NullPointerException("mime_type");
        }
        if (thumb_url == null) {
            throw new NullPointerException("thumb_url");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.id = id;
        this.video_url = video_url;
        this.mime_type = mime_type;
        this.thumb_url = thumb_url;
        this.video_width = video_width;
        this.video_height = video_height;
        this.title = title;
        this.caption = caption;
        this.video_duration = video_duration;
        this.description = description;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultVideoBuilder {
        private String id = Utils.generateRandomString(32);
        private URL video_url;
        private String mime_type;
        private URL thumb_url;
        private int video_width;
        private int video_height;
        private String title;
        private String caption;
        private int video_duration;
        private String description;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultVideoBuilder() {
        }

        public InlineQueryResultVideoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultVideoBuilder videoUrl(URL videoUrl) {
            this.video_url = videoUrl;
            return this;
        }

        public InlineQueryResultVideoBuilder mimeType(String mimeType) {
            this.mime_type = mimeType;
            return this;
        }

        public InlineQueryResultVideoBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultVideoBuilder videoWidth(int videoWidth) {
            this.video_width = videoWidth;
            return this;
        }

        public InlineQueryResultVideoBuilder videoHeight(int videoHeight) {
            this.video_height = videoHeight;
            return this;
        }

        public InlineQueryResultVideoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultVideoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultVideoBuilder videoDuration(int videoDuration) {
            this.video_duration = videoDuration;
            return this;
        }

        public InlineQueryResultVideoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InlineQueryResultVideoBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultVideoBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultVideo build() {
            return new InlineQueryResultVideo(this.id, this.video_url, this.mime_type, this.thumb_url, this.video_width, this.video_height, this.title, this.caption, this.video_duration, this.description, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultVideo.InlineQueryResultVideoBuilder(id=" + this.id + ", video_url=" + this.video_url + ", mime_type=" + this.mime_type + ", thumb_url=" + this.thumb_url + ", video_width=" + this.video_width + ", video_height=" + this.video_height + ", title=" + this.title + ", caption=" + this.caption + ", video_duration=" + this.video_duration + ", description=" + this.description + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

