/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableDocumentMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final InputFile document;
    private final long replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;
    private final String caption;

    public static SendableDocumentMessageBuilder builder() {
        return new SendableDocumentMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.DOCUMENT;
    }

    public String toString() {
        return "SendableDocumentMessage(document=" + this.getDocument() + ", replyTo=" + this.getReplyTo() + ", replyMarkup=" + this.getReplyMarkup() + ", disableNotification=" + this.isDisableNotification() + ", caption=" + this.getCaption() + ")";
    }

    @ConstructorProperties(value={"document", "replyTo", "replyMarkup", "disableNotification", "caption"})
    private SendableDocumentMessage(@NonNull InputFile document, long replyTo, ReplyMarkup replyMarkup, boolean disableNotification, String caption) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        this.document = document;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
        this.caption = caption;
    }

    @NonNull
    public InputFile getDocument() {
        return this.document;
    }

    @Override
    public long getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public String getCaption() {
        return this.caption;
    }

    public static class SendableDocumentMessageBuilder {
        private InputFile document;
        private long replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;
        private String caption;

        SendableDocumentMessageBuilder() {
        }

        public SendableDocumentMessageBuilder document(InputFile document) {
            this.document = document;
            return this;
        }

        public SendableDocumentMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0L;
            return this;
        }

        public SendableDocumentMessageBuilder replyTo(long replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableDocumentMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableDocumentMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableDocumentMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendableDocumentMessage build() {
            return new SendableDocumentMessage(this.document, this.replyTo, this.replyMarkup, this.disableNotification, this.caption);
        }

        public String toString() {
            return "SendableDocumentMessage.SendableDocumentMessageBuilder(document=" + this.document + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ", disableNotification=" + this.disableNotification + ", caption=" + this.caption + ")";
        }
    }
}

