/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableTextMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final String message;
    private final long replyTo;
    private final boolean disableWebPagePreview;
    private final ReplyMarkup replyMarkup;
    private final ParseMode parseMode;
    private final boolean disableNotification;

    public static SendableTextMessageBuilder builder() {
        return new SendableTextMessageBuilder();
    }

    public static SendableTextMessageBuilder markdown(String text) {
        return SendableTextMessage.builder().message(text).parseMode(ParseMode.MARKDOWN);
    }

    public static SendableTextMessageBuilder html(String text) {
        return SendableTextMessage.builder().message(text).parseMode(ParseMode.HTML);
    }

    public static SendableTextMessageBuilder plain(String text) {
        return SendableTextMessage.builder().message(text).parseMode(ParseMode.NONE);
    }

    @Override
    public MessageType getType() {
        return MessageType.TEXT;
    }

    public String toString() {
        return "SendableTextMessage(message=" + this.getMessage() + ", replyTo=" + this.getReplyTo() + ", disableWebPagePreview=" + this.isDisableWebPagePreview() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + (Object)((Object)this.getParseMode()) + ", disableNotification=" + this.isDisableNotification() + ")";
    }

    @ConstructorProperties(value={"message", "replyTo", "disableWebPagePreview", "replyMarkup", "parseMode", "disableNotification"})
    private SendableTextMessage(@NonNull String message, long replyTo, boolean disableWebPagePreview, ReplyMarkup replyMarkup, ParseMode parseMode, boolean disableNotification) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message = message;
        this.replyTo = replyTo;
        this.disableWebPagePreview = disableWebPagePreview;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @Override
    public long getReplyTo() {
        return this.replyTo;
    }

    public boolean isDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public ParseMode getParseMode() {
        return this.parseMode;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableTextMessageBuilder {
        private String message;
        private long replyTo;
        private boolean disableWebPagePreview;
        private ReplyMarkup replyMarkup;
        private ParseMode parseMode;
        private boolean disableNotification;

        SendableTextMessageBuilder() {
        }

        public SendableTextBuilder textBuilder() {
            return new SendableTextBuilder(this);
        }

        public SendableTextMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SendableTextMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0L;
            return this;
        }

        public SendableTextMessageBuilder replyTo(long replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableTextMessageBuilder disableWebPagePreview(boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        public SendableTextMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableTextMessageBuilder parseMode(ParseMode parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public SendableTextMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableTextMessage build() {
            return new SendableTextMessage(this.message, this.replyTo, this.disableWebPagePreview, this.replyMarkup, this.parseMode, this.disableNotification);
        }

        public String toString() {
            return "SendableTextMessage.SendableTextMessageBuilder(message=" + this.message + ", replyTo=" + this.replyTo + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + (Object)((Object)this.parseMode) + ", disableNotification=" + this.disableNotification + ")";
        }
    }

    public static class SendableTextBuilder {
        private final SendableTextMessageBuilder parent;
        private final StringBuilder message = new StringBuilder();

        SendableTextBuilder(SendableTextMessageBuilder parent) {
            this.parent = parent;
        }

        private String htmlEscaped(String text) {
            return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        }

        private SendableTextBuilder element(String e, String content) {
            this.message.append("<").append(e).append(">").append(this.htmlEscaped(content)).append("</").append(e.split(" ")[0]).append(">");
            return this;
        }

        public SendableTextBuilder plain(String text) {
            return this.escaped(text);
        }

        public SendableTextBuilder escaped(String text) {
            return this.html(this.htmlEscaped(text));
        }

        public SendableTextBuilder html(String html) {
            this.message.append(html);
            return this;
        }

        public SendableTextBuilder bold(String text) {
            return this.element("b", text);
        }

        public SendableTextBuilder italics(String text) {
            return this.element("i", text);
        }

        public SendableTextBuilder link(String text, String link) {
            return this.element("a href=\"" + link + "\"", text);
        }

        public SendableTextBuilder code(String text) {
            return this.element("code", text);
        }

        public SendableTextBuilder preformatted(String text) {
            return this.element("pre", text);
        }

        public SendableTextBuilder space() {
            this.message.append(' ');
            return this;
        }

        public SendableTextBuilder newLine() {
            this.message.append("\n");
            return this;
        }

        public SendableTextBuilder nextLine() {
            return this.newLine();
        }

        public SendableTextMessageBuilder buildText() {
            this.parent.message = this.message.toString();
            this.parent.parseMode = ParseMode.HTML;
            return this.parent;
        }
    }
}

