/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableVideoMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final InputFile video;
    private final int duration;
    private final int width;
    private final int height;
    private final String caption;
    private final long replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;

    public static SendableVideoMessageBuilder builder() {
        return new SendableVideoMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.VIDEO;
    }

    public String toString() {
        return "SendableVideoMessage(video=" + this.getVideo() + ", duration=" + this.getDuration() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", caption=" + this.getCaption() + ", replyTo=" + this.getReplyTo() + ", replyMarkup=" + this.getReplyMarkup() + ", disableNotification=" + this.isDisableNotification() + ")";
    }

    @ConstructorProperties(value={"video", "duration", "width", "height", "caption", "replyTo", "replyMarkup", "disableNotification"})
    private SendableVideoMessage(@NonNull InputFile video, int duration, int width, int height, String caption, long replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        if (video == null) {
            throw new NullPointerException("video");
        }
        this.video = video;
        this.duration = duration;
        this.width = width;
        this.height = height;
        this.caption = caption;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public InputFile getVideo() {
        return this.video;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getCaption() {
        return this.caption;
    }

    @Override
    public long getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableVideoMessageBuilder {
        private InputFile video;
        private int duration;
        private int width;
        private int height;
        private String caption;
        private long replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;

        SendableVideoMessageBuilder() {
        }

        public SendableVideoMessageBuilder video(InputFile video) {
            this.video = video;
            return this;
        }

        public SendableVideoMessageBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public SendableVideoMessageBuilder width(int width) {
            this.width = width;
            return this;
        }

        public SendableVideoMessageBuilder height(int height) {
            this.height = height;
            return this;
        }

        public SendableVideoMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendableVideoMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0L;
            return this;
        }

        public SendableVideoMessageBuilder replyTo(long replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableVideoMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableVideoMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableVideoMessage build() {
            return new SendableVideoMessage(this.video, this.duration, this.width, this.height, this.caption, this.replyTo, this.replyMarkup, this.disableNotification);
        }

        public String toString() {
            return "SendableVideoMessage.SendableVideoMessageBuilder(video=" + this.video + ", duration=" + this.duration + ", width=" + this.width + ", height=" + this.height + ", caption=" + this.caption + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ", disableNotification=" + this.disableNotification + ")";
        }
    }
}

