/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.updates;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.CallbackQuery;
import pro.zackpollard.telegrambot.api.chat.inline.ChosenInlineResult;
import pro.zackpollard.telegrambot.api.chat.inline.InlineQuery;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.internal.chat.CallbackQueryImpl;
import pro.zackpollard.telegrambot.api.internal.chat.inline.ChosenInlineResultImpl;
import pro.zackpollard.telegrambot.api.internal.chat.inline.InlineQueryImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.MessageImpl;
import pro.zackpollard.telegrambot.api.updates.Update;

public class UpdateImpl
implements Update {
    private final int update_id;
    private final Message message;
    private final Message edited_message;
    private final Message channel_post;
    private final Message edited_channel_post;
    private final InlineQuery inline_query;
    private final ChosenInlineResult chosen_inline_result;
    private final CallbackQuery callbackQuery;
    private Update.UpdateType updateType;
    private final TelegramBot telegramBot;

    private UpdateImpl(JSONObject jsonObject, TelegramBot telegramBot) {
        this.update_id = jsonObject.getInt("update_id");
        this.message = MessageImpl.createMessage(jsonObject.optJSONObject("message"), telegramBot);
        if (this.message != null) {
            this.updateType = Update.UpdateType.MESSAGE;
        }
        this.edited_message = MessageImpl.createMessage(jsonObject.optJSONObject("edited_message"), telegramBot);
        if (this.edited_message != null && this.updateType == null) {
            this.updateType = Update.UpdateType.EDITED_MESSAGE;
        }
        this.channel_post = MessageImpl.createMessage(jsonObject.optJSONObject("channel_post"), telegramBot);
        if (this.channel_post != null && this.updateType == null) {
            this.updateType = Update.UpdateType.CHANNEL_POST;
        }
        this.edited_channel_post = MessageImpl.createMessage(jsonObject.optJSONObject("edited_channel_post"), telegramBot);
        if (this.edited_channel_post != null && this.updateType == null) {
            this.updateType = Update.UpdateType.EDITED_CHANNEL_POST;
        }
        this.inline_query = InlineQueryImpl.createInlineQuery(jsonObject.optJSONObject("inline_query"));
        if (this.inline_query != null && this.updateType == null) {
            this.updateType = Update.UpdateType.INLINE_QUERY;
        }
        this.chosen_inline_result = ChosenInlineResultImpl.createChosenInlineResult(jsonObject.optJSONObject("chosen_inline_result"));
        if (this.chosen_inline_result != null && this.updateType == null) {
            this.updateType = Update.UpdateType.CHOSEN_INLINE_RESULT;
        }
        this.callbackQuery = CallbackQueryImpl.createCallbackQuery(jsonObject.optJSONObject("callback_query"), telegramBot);
        if (this.callbackQuery != null && this.updateType == null) {
            this.updateType = Update.UpdateType.CALLBACK_QUERY;
        }
        this.telegramBot = telegramBot;
    }

    public static Update createUpdate(JSONObject jsonObject, TelegramBot telegramBot) {
        return new UpdateImpl(jsonObject, telegramBot);
    }

    @Override
    public int getId() {
        return this.update_id;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public Message getEditedMessage() {
        return this.edited_message;
    }

    @Override
    public Message getChannelPost() {
        return this.channel_post;
    }

    @Override
    public Message getEditedChannelPost() {
        return this.edited_channel_post;
    }

    @Override
    public InlineQuery getInlineQuery() {
        return this.inline_query;
    }

    @Override
    public ChosenInlineResult getChosenInlineResult() {
        return this.chosen_inline_result;
    }

    @Override
    public CallbackQuery getCallbackQuery() {
        return this.callbackQuery;
    }

    @Override
    public Update.UpdateType getType() {
        return this.updateType;
    }

    @Override
    public TelegramBot getBotInstance() {
        return this.telegramBot;
    }
}

