/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.user;

import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.type.PhotoSizeImpl;
import pro.zackpollard.telegrambot.api.user.UserProfilePhotos;

public class UserProfilePhotosImpl
implements UserProfilePhotos {
    private final int total_count;
    private final PhotoSize[][] photos;

    private UserProfilePhotosImpl(JSONObject jsonObject) {
        this.total_count = jsonObject.getInt("total_count");
        ArrayList photoList = new ArrayList();
        JSONArray jsonPhotos = jsonObject.getJSONArray("photos");
        for (int i = 0; i < jsonPhotos.length(); ++i) {
            JSONArray jsonPhotoSizes = jsonPhotos.getJSONArray(i);
            ArrayList<PhotoSize> photoSizesList = new ArrayList<PhotoSize>();
            for (int j = 0; j < jsonPhotoSizes.length(); ++j) {
                JSONObject photoObject = jsonPhotoSizes.getJSONObject(j);
                photoSizesList.add(PhotoSizeImpl.createPhotoSize(photoObject));
            }
            photoList.add(photoSizesList);
        }
        this.photos = (PhotoSize[][])photoList.stream().map(l -> (PhotoSize[])l.stream().toArray(PhotoSize[]::new)).toArray(x$0 -> new PhotoSize[x$0][]);
    }

    public static UserProfilePhotos createUserProfilePhotos(long user_id, TelegramBot telegramBot) {
        try {
            JSONObject json = ((JsonNode)Unirest.post((String)(telegramBot.getBotAPIUrl() + "getUserProfilePhotos")).queryString("user_id", (Object)user_id).asJson().getBody()).getObject();
            if (json.getBoolean("ok")) {
                return new UserProfilePhotosImpl(json.getJSONObject("result"));
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int getTotalCount() {
        return this.total_count;
    }

    @Override
    public PhotoSize[][] getPhotos() {
        return this.photos;
    }
}

