/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu;

import java.util.ArrayList;
import java.util.List;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage;
import pro.zackpollard.telegrambot.api.menu.AbstractInlineMenuBuilder;
import pro.zackpollard.telegrambot.api.menu.InlineMenu;
import pro.zackpollard.telegrambot.api.menu.SubInlineMenuBuilder;

public class InlineMenuBuilder
extends AbstractInlineMenuBuilder<InlineMenuBuilder> {
    private final TelegramBot bot;
    private Chat forWhom;
    private SendableTextMessage.SendableTextMessageBuilder messageBuilder;
    private Message message;
    List<InlineMenu> subs = new ArrayList<InlineMenu>();

    InlineMenuBuilder(TelegramBot bot) {
        this.bot = bot;
    }

    public InlineMenuBuilder message(SendableTextMessage.SendableTextMessageBuilder builder) {
        this.messageBuilder = builder;
        return this;
    }

    public InlineMenuBuilder message(Message baseMessage) {
        this.message = baseMessage;
        return this;
    }

    public InlineMenuBuilder forWhom(Chat chat) {
        this.forWhom = chat;
        return this;
    }

    public SubInlineMenuBuilder subMenu() {
        SubInlineMenuBuilder sub = new SubInlineMenuBuilder(this);
        sub.userPredicate = this.userPredicate;
        return sub;
    }

    @Override
    protected InlineMenuBuilder instance() {
        return this;
    }

    @Override
    public InlineMenu buildMenu() {
        Message baseMessage = this.message != null ? this.message : this.bot.sendMessage(this.forWhom, (SendableMessage)this.messageBuilder.build());
        InlineMenu menu = this.buildMenu(baseMessage);
        this.subs.forEach(sub -> {
            sub.baseMessage = baseMessage;
            sub.setParent(menu);
        });
        return menu;
    }
}

