/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu.button;

import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardButton;
import pro.zackpollard.telegrambot.api.menu.InlineMenu;
import pro.zackpollard.telegrambot.api.menu.button.InlineMenuButton;
import pro.zackpollard.telegrambot.api.menu.button.callback.ButtonCallback;

public abstract class AbstractInlineMenuButton
implements InlineMenuButton {
    protected ButtonCallback buttonCallback;
    protected String text;
    protected int row;
    protected InlineMenu owner;

    protected AbstractInlineMenuButton(InlineMenu owner, int row) {
        this.owner = owner;
        this.row = row;
    }

    @Deprecated
    protected AbstractInlineMenuButton(InlineMenu owner, int row, int num) {
        this(owner, row);
    }

    protected AbstractInlineMenuButton(InlineMenu owner, int row, String text) {
        this(owner, row);
        this.text = text;
    }

    @Deprecated
    protected AbstractInlineMenuButton(InlineMenu owner, int row, int num, String text) {
        this(owner, row, text);
    }

    @Override
    public InlineMenu getMenu() {
        return this.owner;
    }

    @Override
    public void setText(String text) {
        if (text != null) {
            this.text = text;
            this.owner.apply();
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ButtonCallback getCallback() {
        return this.buttonCallback;
    }

    @Override
    public InlineMenuButton setCallback(ButtonCallback callback) {
        this.buttonCallback = callback;
        return this;
    }

    @Override
    public void assignMenu(InlineMenu owner) {
        this.owner = owner;
    }

    @Deprecated
    public int getNum() {
        return this.owner.rowAt(this.row).indexOf(this);
    }

    @Override
    public void updateRow(int row) {
        this.row = row;
    }

    protected InlineKeyboardButton.InlineKeyboardButtonBuilder keyboardBuilder() {
        return InlineKeyboardButton.builder().text(this.text).callbackData("im." + this.owner.getInternalId() + "." + this.row + "." + this.owner.rowAt(this.row).indexOf(this));
    }

    public int getRow() {
        return this.row;
    }

    public InlineMenu getOwner() {
        return this.owner;
    }

    public void setOwner(InlineMenu owner) {
        this.owner = owner;
    }
}

