/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.menu.InlineMenu;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRow;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRowBuilder;
import pro.zackpollard.telegrambot.api.user.User;

public abstract class AbstractInlineMenuBuilder<T extends AbstractInlineMenuBuilder> {
    List<InlineMenuRow> rows = new ArrayList<InlineMenuRow>();
    Predicate<User> userPredicate;

    public InlineMenuRowBuilder<T> newRow() {
        return new InlineMenuRowBuilder<T>(this.instance(), this.rows.size());
    }

    public abstract InlineMenu buildMenu();

    protected abstract T instance();

    protected InlineMenu buildMenu(Message base) {
        InlineMenu menu = new InlineMenu(base);
        this.rows.forEach(row -> row.buttons.forEach(button -> button.assignMenu(menu)));
        menu.userPredicate = this.userPredicate;
        menu.rows = this.rows;
        return menu;
    }

    public T removeLast() {
        if (this.rows.size() != 0) {
            this.rows.remove(this.rows.size() - 1);
        }
        return this.instance();
    }

    public T userFilter(Predicate<User> predicate) {
        this.userPredicate = predicate;
        return this.instance();
    }

    public T allowedUsers(User ... users) {
        List<User> usersList = Arrays.asList(users);
        this.userPredicate = user -> usersList.stream().anyMatch(allowedUser -> allowedUser.getId() == user.getId());
        return this.instance();
    }

    public T allowedUser(User allowedUser) {
        this.userPredicate = user2 -> user2.getId() == allowedUser.getId();
        return this.instance();
    }

    public T allowedUsers(long ... userIds) {
        this.userPredicate = user -> {
            for (long id : userIds) {
                if (id != user.getId()) continue;
                return true;
            }
            return false;
        };
        return this.instance();
    }

    public T allowedUser(long userId) {
        this.userPredicate = user -> user.getId() == userId;
        return this.instance();
    }
}

