/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import pro.zackpollard.telegrambot.api.chat.CallbackQuery;
import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardButton;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRowBuilder;
import pro.zackpollard.telegrambot.api.menu.button.InlineMenuButton;

public class InlineMenuRow {
    List<InlineMenuButton> buttons = new LinkedList<InlineMenuButton>();

    InlineMenuRow() {
    }

    public static InlineMenuRowBuilder builder() {
        return new InlineMenuRowBuilder<Object>(null, -1);
    }

    void setIndex(int index) {
        this.buttons.forEach(button -> button.updateRow(index));
    }

    public void addButton(InlineMenuButton button) {
        this.buttons.add(button);
    }

    public void setButton(int index, InlineMenuButton button) {
        this.buttons.set(index, button);
    }

    public int indexOf(InlineMenuButton button) {
        return this.buttons.indexOf(button);
    }

    public InlineMenuButton buttonAt(int index) {
        return this.buttons.get(index);
    }

    public InlineMenuButton removeButton(int index) {
        return this.buttons.remove(index);
    }

    public void removeButton(InlineMenuButton button) {
        this.buttons.remove(button);
    }

    public List<InlineKeyboardButton> toButtons() {
        return this.buttons.stream().map(InlineMenuButton::toKeyboardButton).collect(Collectors.toList());
    }

    public boolean handle(CallbackQuery query, int button) {
        if (button < 0 || button > this.buttons.size()) {
            return false;
        }
        this.buttonAt(button).handlePress(query);
        return true;
    }

    public int size() {
        return this.buttons.size();
    }
}

