/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.CallbackQuery;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage;
import pro.zackpollard.telegrambot.api.extensions.Extensions;
import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardMarkup;
import pro.zackpollard.telegrambot.api.menu.InlineMenuBuilder;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRegistry;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRow;
import pro.zackpollard.telegrambot.api.user.User;

public class InlineMenu {
    private int internalId;
    Message baseMessage;
    @Deprecated
    private InlineMenu parent;
    private InlineMenu lastMenu;
    Predicate<User> userPredicate;
    List<InlineMenuRow> rows;

    InlineMenu(Message baseMessage) {
        this.baseMessage = baseMessage;
    }

    public static InlineMenuBuilder builder(TelegramBot bot) {
        return new InlineMenuBuilder(bot);
    }

    public static InlineMenuBuilder builder(TelegramBot bot, Chat forWhom) {
        return new InlineMenuBuilder(bot).forWhom(forWhom);
    }

    public List<InlineMenuRow> rows() {
        return Collections.unmodifiableList(this.rows);
    }

    public int size() {
        return this.rows.size();
    }

    public void start() {
        ((InlineMenuRegistry)Extensions.get((TelegramBot)this.baseMessage.getBotInstance(), InlineMenuRegistry.class)).register(this);
        this.apply();
    }

    public void unregister() {
        ((InlineMenuRegistry)Extensions.get((TelegramBot)this.baseMessage.getBotInstance(), InlineMenuRegistry.class)).unregister(this);
    }

    public InlineMenuRow rowAt(int index) {
        return this.rows.get(index);
    }

    public void deleteRowAt(int index) {
        this.rows.remove(index);
        this.rows.forEach(row -> row.setIndex(this.rows.indexOf(row)));
        this.apply();
    }

    public void deleteRow(InlineMenuRow row) {
        this.rows.remove(row);
        this.rows.forEach(menuRow -> menuRow.setIndex(this.rows.indexOf(menuRow)));
        this.apply();
    }

    public void addRow(InlineMenuRow row) {
        row.setIndex(this.rows.size());
        this.rows.add(row);
        this.apply();
    }

    public void setRow(int index, InlineMenuRow row) {
        row.setIndex(index);
        this.rows.set(index, row);
        this.apply();
    }

    public InlineKeyboardMarkup toKeyboard() {
        InlineKeyboardMarkup.InlineKeyboardMarkupBuilder builder = InlineKeyboardMarkup.builder();
        if (this.rows.isEmpty()) {
            return null;
        }
        this.rows.stream().map(InlineMenuRow::toButtons).forEach(arg_0 -> ((InlineKeyboardMarkup.InlineKeyboardMarkupBuilder)builder).addRow(arg_0));
        return builder.build();
    }

    public boolean handle(CallbackQuery query, int row, int button) {
        if (!InlineMenu.validateCaller(InlineMenuRegistry.class)) {
            throw new UnsupportedOperationException("Invalid caller! Caller must implement InlineMenuRegistry");
        }
        return (this.userPredicate == null || this.userPredicate.test(query.getFrom())) && row < this.rows.size() && this.rowAt(row).handle(query, button);
    }

    public void apply() {
        this.baseMessage.getBotInstance().editMessageReplyMarkup(this.baseMessage, (InlineReplyMarkup)this.toKeyboard());
    }

    public void setMessageText(SendableTextMessage.SendableTextMessageBuilder messageBuilder) {
        SendableTextMessage message = messageBuilder.build();
        this.baseMessage.getBotInstance().editMessageText(this.baseMessage, message.getMessage(), message.getParseMode(), message.isDisableWebPagePreview(), (InlineReplyMarkup)this.toKeyboard());
    }

    public void setInternalId(int newId) {
        if (!InlineMenu.validateCaller(InlineMenuRegistry.class)) {
            throw new UnsupportedOperationException("Invalid caller! Caller must implement InlineMenuRegistry");
        }
        this.internalId = newId;
    }

    private static boolean validateCaller(Class<?> intendedClass) {
        Class<?> callingClass;
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        String rawFQN = stElements[3].toString().split("\\(")[0];
        try {
            callingClass = Class.forName(rawFQN.substring(0, rawFQN.lastIndexOf(46)));
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        return intendedClass.isAssignableFrom(callingClass);
    }

    public int getInternalId() {
        return this.internalId;
    }

    public Message getBaseMessage() {
        return this.baseMessage;
    }

    @Deprecated
    public InlineMenu getParent() {
        return this.parent;
    }

    @Deprecated
    public void setParent(InlineMenu parent) {
        this.parent = parent;
    }

    public InlineMenu getLastMenu() {
        return this.lastMenu;
    }

    public void setLastMenu(InlineMenu lastMenu) {
        this.lastMenu = lastMenu;
    }
}

