/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu;

import java.util.List;
import pro.zackpollard.telegrambot.api.menu.AbstractInlineMenuBuilder;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRow;
import pro.zackpollard.telegrambot.api.menu.SubInlineMenuBuilder;
import pro.zackpollard.telegrambot.api.menu.button.InlineMenuButton;
import pro.zackpollard.telegrambot.api.menu.button.builder.BackButtonBuilder;
import pro.zackpollard.telegrambot.api.menu.button.builder.DummyButtonBuilder;
import pro.zackpollard.telegrambot.api.menu.button.builder.SubInlineMenuButtonBuilder;
import pro.zackpollard.telegrambot.api.menu.button.builder.ToggleInlineMenuButtonBuilder;
import pro.zackpollard.telegrambot.api.menu.button.builder.UserInputInlineMenuButtonBuilder;

public class InlineMenuRowBuilder<T extends AbstractInlineMenuBuilder> {
    private final T parent;
    private final InlineMenuRow row = new InlineMenuRow();
    private final int index;

    InlineMenuRowBuilder(T parent, int index) {
        this.parent = parent;
        this.index = index;
    }

    public void internalAddButton(InlineMenuButton button) {
        this.row.buttons.add(button);
    }

    public ToggleInlineMenuButtonBuilder<T> toggleButton() {
        return new ToggleInlineMenuButtonBuilder(this);
    }

    public ToggleInlineMenuButtonBuilder<T> toggleButton(String text) {
        return new ToggleInlineMenuButtonBuilder(this, text);
    }

    public UserInputInlineMenuButtonBuilder<T> inputButton() {
        return new UserInputInlineMenuButtonBuilder(this);
    }

    public UserInputInlineMenuButtonBuilder<T> inputButton(String text) {
        return new UserInputInlineMenuButtonBuilder(this, text);
    }

    public SubInlineMenuButtonBuilder<T> menuButton() {
        return new SubInlineMenuButtonBuilder(this);
    }

    public SubInlineMenuButtonBuilder<T> menuButton(String text) {
        return new SubInlineMenuButtonBuilder(this, text);
    }

    public BackButtonBuilder<T> backButton() {
        if (!(this.parent instanceof SubInlineMenuBuilder)) {
            throw new UnsupportedOperationException("Back buttons are only allowed for sub menus!");
        }
        return new BackButtonBuilder(this);
    }

    public BackButtonBuilder<T> backButton(String text) {
        return new BackButtonBuilder(this, text);
    }

    public DummyButtonBuilder<T> dummyButton(String text) {
        return new DummyButtonBuilder(this, text);
    }

    public DummyButtonBuilder<T> dummyButton() {
        return new DummyButtonBuilder(this);
    }

    public InlineMenuRowBuilder removeLast() {
        List<InlineMenuButton> buttons = this.buttons();
        if (buttons.size() != 0) {
            buttons.remove(buttons.size() - 1);
        }
        return this;
    }

    public int rowIndex() {
        return this.index;
    }

    private List<InlineMenuButton> buttons() {
        return this.row.buttons;
    }

    public InlineMenuRow buildRow() {
        return this.row;
    }

    public T build() {
        ((AbstractInlineMenuBuilder)this.parent).rows.add(this.row);
        return this.parent;
    }

    public InlineMenuRowBuilder<T> newRow() {
        this.build();
        return ((AbstractInlineMenuBuilder)this.parent).newRow();
    }
}

