/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableForwardMessage
implements SendableMessage {
    @NonNull
    private final Message forwardedMessage;

    @Override
    public MessageType getType() {
        return MessageType.FORWARDED;
    }

    public static SendableForwardMessageBuilder builder() {
        return new SendableForwardMessageBuilder();
    }

    @ConstructorProperties(value={"forwardedMessage"})
    public SendableForwardMessage(@NonNull Message forwardedMessage) {
        if (forwardedMessage == null) {
            throw new NullPointerException("forwardedMessage");
        }
        this.forwardedMessage = forwardedMessage;
    }

    @NonNull
    public Message getForwardedMessage() {
        return this.forwardedMessage;
    }

    public static class SendableForwardMessageBuilder {
        private Message forwardedMessage;

        SendableForwardMessageBuilder() {
        }

        public SendableForwardMessageBuilder forwardedMessage(Message forwardedMessage) {
            this.forwardedMessage = forwardedMessage;
            return this;
        }

        public SendableForwardMessage build() {
            return new SendableForwardMessage(this.forwardedMessage);
        }

        public String toString() {
            return "SendableForwardMessage.SendableForwardMessageBuilder(forwardedMessage=" + this.forwardedMessage + ")";
        }
    }
}

