/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message.content.type;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Video;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.type.PhotoSizeImpl;

public class VideoImpl
implements Video {
    private final String file_id;
    private final int width;
    private final int height;
    private final int duration;
    private final PhotoSize thumb;
    private final String mime_type;
    private final int file_size;

    private VideoImpl(JSONObject jsonObject) {
        this.file_id = jsonObject.getString("file_id");
        this.width = jsonObject.getInt("width");
        this.height = jsonObject.getInt("height");
        this.duration = jsonObject.getInt("duration");
        this.thumb = PhotoSizeImpl.createPhotoSize(jsonObject.optJSONObject("thumb"));
        this.mime_type = jsonObject.optString("mime_type");
        this.file_size = jsonObject.optInt("file_size");
    }

    public static Video createVideo(JSONObject jsonObject) {
        return jsonObject != null ? new VideoImpl(jsonObject) : null;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public String getFileId() {
        return this.file_id;
    }

    @Override
    public int getSize() {
        return this.file_size;
    }

    @Override
    public String getMimeType() {
        return this.mime_type;
    }

    @Override
    public PhotoSize getThumbnail() {
        return this.thumb;
    }
}

