/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableTextMessage
implements SendableMessage,
ReplyingOptions {
    @NonNull
    private final String message;
    private final Message replyTo;
    private final boolean disableWebPagePreview;
    private final ReplyMarkup replyMarkup;
    private final ParseMode parseMode;

    @Override
    public MessageType getType() {
        return MessageType.TEXT;
    }

    public static SendableTextMessageBuilder builder() {
        return new SendableTextMessageBuilder();
    }

    @ConstructorProperties(value={"message", "replyTo", "disableWebPagePreview", "replyMarkup", "parseMode"})
    public SendableTextMessage(@NonNull String message, Message replyTo, boolean disableWebPagePreview, ReplyMarkup replyMarkup, ParseMode parseMode) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message = message;
        this.replyTo = replyTo;
        this.disableWebPagePreview = disableWebPagePreview;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @Override
    public Message getReplyTo() {
        return this.replyTo;
    }

    public boolean isDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public ParseMode getParseMode() {
        return this.parseMode;
    }

    public static class SendableTextMessageBuilder {
        private String message;
        private Message replyTo;
        private boolean disableWebPagePreview;
        private ReplyMarkup replyMarkup;
        private ParseMode parseMode;

        SendableTextMessageBuilder() {
        }

        public SendableTextMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SendableTextMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableTextMessageBuilder disableWebPagePreview(boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        public SendableTextMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableTextMessageBuilder parseMode(ParseMode parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public SendableTextMessage build() {
            return new SendableTextMessage(this.message, this.replyTo, this.disableWebPagePreview, this.replyMarkup, this.parseMode);
        }

        public String toString() {
            return "SendableTextMessage.SendableTextMessageBuilder(message=" + this.message + ", replyTo=" + this.replyTo + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + (Object)((Object)this.parseMode) + ")";
        }
    }
}

