/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableVideoMessage
implements SendableMessage,
ReplyingOptions {
    @NonNull
    private final InputFile video;
    private final int duration;
    private final String caption;
    private final Message replyTo;
    private final ReplyMarkup replyMarkup;

    @Override
    public MessageType getType() {
        return MessageType.VIDEO;
    }

    public static SendableVideoMessageBuilder builder() {
        return new SendableVideoMessageBuilder();
    }

    @ConstructorProperties(value={"video", "duration", "caption", "replyTo", "replyMarkup"})
    public SendableVideoMessage(@NonNull InputFile video, int duration, String caption, Message replyTo, ReplyMarkup replyMarkup) {
        if (video == null) {
            throw new NullPointerException("video");
        }
        this.video = video;
        this.duration = duration;
        this.caption = caption;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
    }

    @NonNull
    public InputFile getVideo() {
        return this.video;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getCaption() {
        return this.caption;
    }

    @Override
    public Message getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public static class SendableVideoMessageBuilder {
        private InputFile video;
        private int duration;
        private String caption;
        private Message replyTo;
        private ReplyMarkup replyMarkup;

        SendableVideoMessageBuilder() {
        }

        public SendableVideoMessageBuilder video(InputFile video) {
            this.video = video;
            return this;
        }

        public SendableVideoMessageBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public SendableVideoMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendableVideoMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableVideoMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableVideoMessage build() {
            return new SendableVideoMessage(this.video, this.duration, this.caption, this.replyTo, this.replyMarkup);
        }

        public String toString() {
            return "SendableVideoMessage.SendableVideoMessageBuilder(video=" + this.video + ", duration=" + this.duration + ", caption=" + this.caption + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

