/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message.content.type;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Sticker;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.type.PhotoSizeImpl;

public class StickerImpl
implements Sticker {
    private final String file_id;
    private final int width;
    private final int height;
    private final PhotoSize thumb;
    private final int file_size;

    private StickerImpl(JSONObject jsonObject) {
        this.file_id = jsonObject.getString("file_id");
        this.width = jsonObject.getInt("width");
        this.height = jsonObject.getInt("height");
        this.thumb = PhotoSizeImpl.createPhotoSize(jsonObject.optJSONObject("thumb"));
        this.file_size = jsonObject.optInt("file_size");
    }

    public static Sticker createSticker(JSONObject jsonObject) {
        return jsonObject != null ? new StickerImpl(jsonObject) : null;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getFileId() {
        return this.file_id;
    }

    @Override
    public int getSize() {
        return this.file_size;
    }

    @Override
    public PhotoSize getThumbnail() {
        return this.thumb;
    }
}

