/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.updates;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.message.content.TextContent;
import pro.zackpollard.telegrambot.api.event.chat.ChannelChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.DeleteGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.GroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.MigrateFromChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.MigrateToChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatTitleEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantJoinGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantLeaveGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.SuperGroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.AudioMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.CommandMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.ContactMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.DocumentMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.LocationMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.PhotoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.StickerMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.TextMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VideoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VoiceMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.internal.event.ListenerRegistryImpl;
import pro.zackpollard.telegrambot.api.internal.updates.UpdateImpl;
import pro.zackpollard.telegrambot.api.updates.Update;
import pro.zackpollard.telegrambot.api.updates.UpdateManager;

public class RequestUpdatesManager
extends UpdateManager {
    private final ListenerRegistryImpl eventManager;

    public RequestUpdatesManager(TelegramBot telegramBot, boolean getPreviousUpdates) {
        super(telegramBot);
        this.eventManager = (ListenerRegistryImpl)telegramBot.getEventsManager();
        new Thread(new UpdaterRunnable(this, getPreviousUpdates)).start();
    }

    @Override
    public UpdateManager.UpdateMethod getUpdateMethod() {
        return UpdateManager.UpdateMethod.REQUEST_UPDATES;
    }

    private class UpdaterRunnable
    implements Runnable {
        private final RequestUpdatesManager requestUpdatesManager;
        private final long unixTime;
        private boolean getPreviousUpdates;

        protected UpdaterRunnable(RequestUpdatesManager requestUpdatesManager2, boolean getPreviousUpdates) {
            this.requestUpdatesManager = requestUpdatesManager2;
            this.getPreviousUpdates = getPreviousUpdates;
            this.unixTime = System.currentTimeMillis() / 1000L;
        }

        @Override
        public void run() {
            int offset = 0;
            while (true) {
                HttpResponse response = null;
                try {
                    response = Unirest.post((String)(this.requestUpdatesManager.getTelegramBot().getBotAPIUrl() + "getUpdates")).field("offset", (Object)(offset + 1), "application/json").field("timeout", (Object)10).asString();
                }
                catch (UnirestException e) {
                    System.err.println("There was a connection error when trying to retrieve updates, waiting for 1 second and then trying again.");
                    System.err.println(e.getLocalizedMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (JSONException e) {
                    System.err.println("There was a JSON error, suspected API error, waiting for 1 second and then trying again.");
                    System.err.println(e.getMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (response != null && response.getStatus() == 200) {
                    JSONObject jsonResponse;
                    try {
                        jsonResponse = new JSONObject((String)response.getBody());
                    }
                    catch (JSONException e) {
                        System.err.println("API didn't return a JSON response. Response content was: " + (String)response.getBody());
                        continue;
                    }
                    if (jsonResponse.getBoolean("ok")) {
                        JSONArray updates = jsonResponse.getJSONArray("result");
                        for (int i = 0; i < updates.length(); ++i) {
                            Update update = UpdateImpl.createUpdate(updates.getJSONObject(i));
                            if (!this.getPreviousUpdates) {
                                if ((long)update.getMessage().getTimeStamp() < this.unixTime) break;
                                this.getPreviousUpdates = true;
                            }
                            try {
                                RequestUpdatesManager.this.eventManager.callEvent(new MessageReceivedEvent(update.getMessage()));
                                switch (update.getMessage().getContent().getType()) {
                                    case AUDIO: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new AudioMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case CONTACT: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new ContactMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case DELETE_CHAT_PHOTO: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new DeleteGroupChatPhotoEvent(update.getMessage()));
                                        break;
                                    }
                                    case DOCUMENT: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new DocumentMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case LOCATION: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new LocationMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case NEW_CHAT_TITLE: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new NewGroupChatTitleEvent(update.getMessage()));
                                        break;
                                    }
                                    case NEW_CHAT_PARTICIPANT: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new ParticipantJoinGroupChatEvent(update.getMessage()));
                                        break;
                                    }
                                    case PHOTO: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new PhotoMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case STICKER: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new StickerMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case TEXT: {
                                        if (((TextContent)update.getMessage().getContent()).getContent().startsWith("/")) {
                                            RequestUpdatesManager.this.eventManager.callEvent(new CommandMessageReceivedEvent(update.getMessage()));
                                            break;
                                        }
                                        RequestUpdatesManager.this.eventManager.callEvent(new TextMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case VIDEO: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new VideoMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case VOICE: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new VoiceMessageReceivedEvent(update.getMessage()));
                                        break;
                                    }
                                    case GROUP_CHAT_CREATED: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new GroupChatCreatedEvent(update.getMessage()));
                                        break;
                                    }
                                    case LEFT_CHAT_PARTICIPANT: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new ParticipantLeaveGroupChatEvent(update.getMessage()));
                                        break;
                                    }
                                    case NEW_CHAT_PHOTO: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new NewGroupChatPhotoEvent(update.getMessage()));
                                        break;
                                    }
                                    case CHANNEL_CHAT_CREATED: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new ChannelChatCreatedEvent(update.getMessage()));
                                        break;
                                    }
                                    case MIGRATE_FROM_CHAT_ID: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new MigrateFromChatEvent(update.getMessage()));
                                        break;
                                    }
                                    case MIGRATE_TO_CHAT_ID: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new MigrateToChatEvent(update.getMessage()));
                                        break;
                                    }
                                    case SUPER_GROUP_CHAT_CREATED: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new SuperGroupChatCreatedEvent(update.getMessage()));
                                    }
                                }
                                continue;
                            }
                            catch (Exception e) {
                                System.err.println("An error occurred during an event, check the stacktrace below for a more detailed error.");
                                e.printStackTrace();
                            }
                        }
                        if (updates.length() != 0) {
                            offset = updates.getJSONObject(updates.length() - 1).getInt("update_id");
                        }
                    } else {
                        System.err.println("The API returned the following error: " + jsonResponse.getString("description"));
                    }
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

