/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableAudioMessage
implements SendableMessage,
ReplyingOptions {
    @NonNull
    private final InputFile audio;
    private final int duration;
    private final String performer;
    private final String title;
    private final Message replyTo;
    private final ReplyMarkup replyMarkup;

    @Override
    public MessageType getType() {
        return MessageType.AUDIO;
    }

    public static SendableAudioMessageBuilder builder() {
        return new SendableAudioMessageBuilder();
    }

    @ConstructorProperties(value={"audio", "duration", "performer", "title", "replyTo", "replyMarkup"})
    public SendableAudioMessage(@NonNull InputFile audio, int duration, String performer, String title, Message replyTo, ReplyMarkup replyMarkup) {
        if (audio == null) {
            throw new NullPointerException("audio");
        }
        this.audio = audio;
        this.duration = duration;
        this.performer = performer;
        this.title = title;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
    }

    @NonNull
    public InputFile getAudio() {
        return this.audio;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public Message getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public static class SendableAudioMessageBuilder {
        private InputFile audio;
        private int duration;
        private String performer;
        private String title;
        private Message replyTo;
        private ReplyMarkup replyMarkup;

        SendableAudioMessageBuilder() {
        }

        public SendableAudioMessageBuilder audio(InputFile audio) {
            this.audio = audio;
            return this;
        }

        public SendableAudioMessageBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public SendableAudioMessageBuilder performer(String performer) {
            this.performer = performer;
            return this;
        }

        public SendableAudioMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SendableAudioMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableAudioMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableAudioMessage build() {
            return new SendableAudioMessage(this.audio, this.duration, this.performer, this.title, this.replyTo, this.replyMarkup);
        }

        public String toString() {
            return "SendableAudioMessage.SendableAudioMessageBuilder(audio=" + this.audio + ", duration=" + this.duration + ", performer=" + this.performer + ", title=" + this.title + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

