/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableLocationMessage
implements SendableMessage,
ReplyingOptions {
    @NonNull
    private final double latitude;
    @NonNull
    private final double longitude;
    private final Message replyTo;
    private final ReplyMarkup replyMarkup;

    @Override
    public MessageType getType() {
        return MessageType.LOCATION;
    }

    public static SendableLocationMessageBuilder builder() {
        return new SendableLocationMessageBuilder();
    }

    @ConstructorProperties(value={"latitude", "longitude", "replyTo", "replyMarkup"})
    public SendableLocationMessage(@NonNull double latitude, @NonNull double longitude, Message replyTo, ReplyMarkup replyMarkup) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
    }

    @NonNull
    public double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public Message getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public static class SendableLocationMessageBuilder {
        private double latitude;
        private double longitude;
        private Message replyTo;
        private ReplyMarkup replyMarkup;

        SendableLocationMessageBuilder() {
        }

        public SendableLocationMessageBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public SendableLocationMessageBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public SendableLocationMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableLocationMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableLocationMessage build() {
            return new SendableLocationMessage(this.latitude, this.longitude, this.replyTo, this.replyMarkup);
        }

        public String toString() {
            return "SendableLocationMessage.SendableLocationMessageBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

