/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message.content;

import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.message.content.PhotoContent;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.type.PhotoSizeImpl;

public class PhotoContentImpl
implements PhotoContent {
    private final PhotoSize[] content;
    private final String caption;

    private PhotoContentImpl(JSONArray jsonArray, String caption) {
        ArrayList<PhotoSize> photoSizeList = new ArrayList<PhotoSize>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject photoObject = jsonArray.getJSONObject(i);
            photoSizeList.add(PhotoSizeImpl.createPhotoSize(photoObject));
        }
        this.content = (PhotoSize[])photoSizeList.stream().toArray(PhotoSize[]::new);
        this.caption = caption;
    }

    public static PhotoContent createPhotoContent(JSONArray jsonArray, String caption) {
        return jsonArray != null ? new PhotoContentImpl(jsonArray, caption) : null;
    }

    @Override
    public PhotoSize[] getContent() {
        return this.content;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }
}

