/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultGif
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.GIF;
    @NonNull
    private final String id;
    @NonNull
    private final URL gif_url;
    private final int gif_width;
    private final int gif_height;
    @NonNull
    private final URL thumb_url;
    private final String title;
    private final String caption;
    private final String message_text;
    private final ParseMode parse_mode;
    private final boolean disable_web_page_preview;

    public static InlineQueryResultGifBuilder builder() {
        return new InlineQueryResultGifBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getGifUrl() {
        return this.gif_url;
    }

    public int getGifWidth() {
        return this.gif_width;
    }

    public int getGifHeight() {
        return this.gif_height;
    }

    @NonNull
    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getMessageText() {
        return this.message_text;
    }

    public ParseMode getParseMode() {
        return this.parse_mode;
    }

    public boolean isDisableWebPagePreview() {
        return this.disable_web_page_preview;
    }

    private InlineQueryResultGif(@NonNull String id, @NonNull URL gif_url, int gif_width, int gif_height, @NonNull URL thumb_url, String title, String caption, String message_text, ParseMode parse_mode, boolean disable_web_page_preview) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (gif_url == null) {
            throw new NullPointerException("gif_url");
        }
        if (thumb_url == null) {
            throw new NullPointerException("thumb_url");
        }
        this.id = id;
        this.gif_url = gif_url;
        this.gif_width = gif_width;
        this.gif_height = gif_height;
        this.thumb_url = thumb_url;
        this.title = title;
        this.caption = caption;
        this.message_text = message_text;
        this.parse_mode = parse_mode;
        this.disable_web_page_preview = disable_web_page_preview;
    }

    public static class InlineQueryResultGifBuilder {
        private String id = Utils.generateRandomString(32);
        private URL gif_url;
        private int gif_width;
        private int gif_height;
        private URL thumb_url;
        private String title;
        private String caption;
        private String message_text;
        private ParseMode parse_mode;
        private boolean disable_web_page_preview;

        InlineQueryResultGifBuilder() {
        }

        public InlineQueryResultGifBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultGifBuilder gifUrl(URL gifUrl) {
            this.gif_url = gifUrl;
            return this;
        }

        public InlineQueryResultGifBuilder gifWidth(int gifWidth) {
            this.gif_width = gifWidth;
            return this;
        }

        public InlineQueryResultGifBuilder gifHeight(int gifHeight) {
            this.gif_height = gifHeight;
            return this;
        }

        public InlineQueryResultGifBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultGifBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultGifBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultGifBuilder messageText(String messageText) {
            this.message_text = messageText;
            return this;
        }

        public InlineQueryResultGifBuilder parseMode(ParseMode parseMode) {
            this.parse_mode = parseMode;
            return this;
        }

        public InlineQueryResultGifBuilder disableWebPagePreview(boolean disableWebPagePreview) {
            this.disable_web_page_preview = disableWebPagePreview;
            return this;
        }

        public InlineQueryResultGif build() {
            return new InlineQueryResultGif(this.id, this.gif_url, this.gif_width, this.gif_height, this.thumb_url, this.title, this.caption, this.message_text, this.parse_mode, this.disable_web_page_preview);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultGif.InlineQueryResultGifBuilder(id=" + this.id + ", gif_url=" + this.gif_url + ", gif_width=" + this.gif_width + ", gif_height=" + this.gif_height + ", thumb_url=" + this.thumb_url + ", title=" + this.title + ", caption=" + this.caption + ", message_text=" + this.message_text + ", parse_mode=" + (Object)((Object)this.parse_mode) + ", disable_web_page_preview=" + this.disable_web_page_preview + ")";
        }
    }
}

