/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableDocumentMessage
implements SendableMessage,
ReplyingOptions {
    @NonNull
    private final InputFile document;
    private final int replyTo;
    private final ReplyMarkup replyMarkup;

    public SendableDocumentMessage(InputFile document, Message replyTo, ReplyMarkup replyMarkup) {
        this(document, replyTo != null ? replyTo.getMessageId() : 0, replyMarkup);
    }

    public static SendableDocumentMessageBuilder builder() {
        return new SendableDocumentMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.DOCUMENT;
    }

    @ConstructorProperties(value={"document", "replyTo", "replyMarkup"})
    public SendableDocumentMessage(@NonNull InputFile document, int replyTo, ReplyMarkup replyMarkup) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        this.document = document;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
    }

    @NonNull
    public InputFile getDocument() {
        return this.document;
    }

    @Override
    public int getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public static class SendableDocumentMessageBuilder {
        private InputFile document;
        private int replyTo;
        private ReplyMarkup replyMarkup;

        SendableDocumentMessageBuilder() {
        }

        public SendableDocumentMessageBuilder document(InputFile document) {
            this.document = document;
            return this;
        }

        public SendableDocumentMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0;
            return this;
        }

        public SendableDocumentMessageBuilder replyTo(int replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableDocumentMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableDocumentMessage build() {
            return new SendableDocumentMessage(this.document, this.replyTo, this.replyMarkup);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableDocumentMessage.SendableDocumentMessageBuilder(document=" + this.document + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

