/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableForwardMessage
implements SendableMessage {
    @NonNull
    private final Integer messageID;
    @NonNull
    private final String chatID;

    SendableForwardMessage(Message forwardedMessage) {
        this(forwardedMessage != null ? Integer.valueOf(forwardedMessage.getMessageId()) : null, forwardedMessage != null ? forwardedMessage.getChat().getId() : null);
    }

    public static SendableForwardMessageBuilder builder() {
        return new SendableForwardMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.FORWARDED;
    }

    @ConstructorProperties(value={"messageID", "chatID"})
    public SendableForwardMessage(@NonNull Integer messageID, @NonNull String chatID) {
        if (messageID == null) {
            throw new NullPointerException("messageID");
        }
        if (chatID == null) {
            throw new NullPointerException("chatID");
        }
        this.messageID = messageID;
        this.chatID = chatID;
    }

    @NonNull
    public Integer getMessageID() {
        return this.messageID;
    }

    @NonNull
    public String getChatID() {
        return this.chatID;
    }

    public static class SendableForwardMessageBuilder {
        private Integer messageID;
        private String chatID;

        SendableForwardMessageBuilder() {
        }

        public SendableForwardMessageBuilder forwardedMessage(Message forwardedMessage) {
            this.messageID = forwardedMessage != null ? Integer.valueOf(forwardedMessage.getMessageId()) : null;
            this.chatID = forwardedMessage != null ? forwardedMessage.getChat().getId() : null;
            return this;
        }

        public SendableForwardMessageBuilder messageID(Integer messageID) {
            this.messageID = messageID;
            return this;
        }

        public SendableForwardMessageBuilder chatID(String chatID) {
            this.chatID = chatID;
            return this;
        }

        public SendableForwardMessage build() {
            return new SendableForwardMessage(this.messageID, this.chatID);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableForwardMessage.SendableForwardMessageBuilder(messageID=" + this.messageID + ", chatID=" + this.chatID + ")";
        }
    }
}

