/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendablePhotoMessage
implements SendableMessage,
ReplyingOptions {
    @NonNull
    private final InputFile photo;
    private final String caption;
    private final int replyTo;
    private final ReplyMarkup replyMarkup;

    public SendablePhotoMessage(InputFile photo, String caption, Message replyTo, ReplyMarkup replyMarkup) {
        this(photo, caption, replyTo != null ? replyTo.getMessageId() : 0, replyMarkup);
    }

    public static SendablePhotoMessageBuilder builder() {
        return new SendablePhotoMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.PHOTO;
    }

    @ConstructorProperties(value={"photo", "caption", "replyTo", "replyMarkup"})
    public SendablePhotoMessage(@NonNull InputFile photo, String caption, int replyTo, ReplyMarkup replyMarkup) {
        if (photo == null) {
            throw new NullPointerException("photo");
        }
        this.photo = photo;
        this.caption = caption;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
    }

    @NonNull
    public InputFile getPhoto() {
        return this.photo;
    }

    public String getCaption() {
        return this.caption;
    }

    @Override
    public int getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public static class SendablePhotoMessageBuilder {
        private InputFile photo;
        private String caption;
        private int replyTo;
        private ReplyMarkup replyMarkup;

        SendablePhotoMessageBuilder() {
        }

        public SendablePhotoMessageBuilder photo(InputFile photo) {
            this.photo = photo;
            return this;
        }

        public SendablePhotoMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendablePhotoMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0;
            return this;
        }

        public SendablePhotoMessageBuilder replyTo(int replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendablePhotoMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendablePhotoMessage build() {
            return new SendablePhotoMessage(this.photo, this.caption, this.replyTo, this.replyMarkup);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendablePhotoMessage.SendablePhotoMessageBuilder(photo=" + this.photo + ", caption=" + this.caption + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

